/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummary;
import com.h3xstream.findsecbugs.taintanalysis.TaintMethodSummaryMap;
import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.InvalidBytecodeException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Collection;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.NEW;

public class TaintFrameModelingVisitor
extends AbstractFrameModelingVisitor<Taint, TaintFrame> {
    private static final String TO_STRING_METHOD = "toString()Ljava/lang/String;";
    private final TaintMethodSummaryMap methodSummaries;

    public TaintFrameModelingVisitor(ConstantPoolGen cpg, TaintMethodSummaryMap methodSummaries) {
        super(cpg);
        this.methodSummaries = methodSummaries;
    }

    public Taint getDefaultValue() {
        return new Taint(Taint.State.UNKNOWN);
    }

    public void visitLDC(LDC obj) {
        this.pushSafe();
    }

    public void visitLDC2_W(LDC2_W obj) {
        this.pushSafe();
        this.pushSafe();
    }

    public void visitACONST_NULL(ACONST_NULL obj) {
        ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.NULL));
    }

    public void visitNEW(NEW obj) {
        this.pushSafe();
    }

    public void handleLoadInstruction(LoadInstruction obj) {
        int numProduced = obj.produceStack(this.cpg);
        if (numProduced == -2) {
            throw new InvalidBytecodeException("Unpredictable stack production");
        }
        int index = obj.getIndex() + numProduced;
        while (numProduced-- > 0) {
            Taint value = (Taint)((TaintFrame)this.getFrame()).getValue(--index);
            value.setLocalVariableIndex(index);
            ((TaintFrame)this.getFrame()).pushValue(value);
        }
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.visitInvoke((InvokeInstruction)obj);
    }

    public void visitAALOAD(AALOAD obj) {
        try {
            Taint arrayTaint = (Taint)((TaintFrame)this.getFrame()).getStackValue(1);
            Taint pushTaint = new Taint(arrayTaint.getState());
            this.modelInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), this.getNumWordsProduced((Instruction)obj), pushTaint);
        }
        catch (DataflowAnalysisException ex) {
            throw new InvalidBytecodeException("Not enough values on the stack", (Throwable)ex);
        }
    }

    private void visitInvoke(InvokeInstruction obj) {
        TaintMethodSummary methodSummary = this.getMethodSummary(obj);
        Taint taint = this.getMethodTaint(methodSummary);
        if (taint.getState() == Taint.State.UNKNOWN) {
            taint.addTaintLocation(this.getLocation(), false);
        }
        this.transferTaintToMutables(methodSummary, taint);
        this.modelInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), this.getNumWordsProduced((Instruction)obj), taint);
    }

    private TaintMethodSummary getMethodSummary(InvokeInstruction obj) {
        String methodNameWithSig = obj.getMethodName(this.cpg) + obj.getSignature(this.cpg);
        String fullMethodName = this.getSlashedClassName((FieldOrMethod)obj) + "." + methodNameWithSig;
        TaintMethodSummary methodSummary = (TaintMethodSummary)this.methodSummaries.get(fullMethodName);
        if (methodSummary == null && TO_STRING_METHOD.equals(methodNameWithSig)) {
            methodSummary = TaintMethodSummary.getDefaultToStringSummary();
        }
        return methodSummary;
    }

    private String getSlashedClassName(FieldOrMethod obj) {
        String className = obj.getReferenceType(this.cpg).toString();
        return ClassName.toSlashedClassName((String)className);
    }

    private Taint getMethodTaint(TaintMethodSummary methodSummary) {
        if (methodSummary == null) {
            return this.getDefaultValue();
        }
        if (methodSummary.hasConstantOutputTaint()) {
            Taint taint = new Taint(methodSummary.getOutputTaint());
            if (taint.getState() == Taint.State.TAINTED) {
                taint.addTaintLocation(this.getLocation(), true);
            }
            return taint;
        }
        if (methodSummary.hasTransferParameters()) {
            return this.mergeTransferParameters(methodSummary.getTransferParameters());
        }
        throw new IllegalStateException("invalid method summary");
    }

    private Taint mergeTransferParameters(Collection<Integer> transferParameters) {
        Taint taint = null;
        assert (!transferParameters.isEmpty());
        for (Integer transferParameter : transferParameters) {
            try {
                Taint value = (Taint)((TaintFrame)this.getFrame()).getStackValue(transferParameter);
                taint = taint == null ? value : Taint.merge(taint, value);
            }
            catch (DataflowAnalysisException ex) {
                throw new RuntimeException("Bad transfer parameter specification", ex);
            }
        }
        assert (taint != null);
        return taint;
    }

    private void transferTaintToMutables(TaintMethodSummary methodSummary, Taint taint) throws RuntimeException {
        if (methodSummary == null || !methodSummary.hasMutableStackIndex()) {
            return;
        }
        int mutableStackIndex = methodSummary.getMutableStackIndex();
        try {
            Taint stackValue = (Taint)((TaintFrame)this.getFrame()).getStackValue(mutableStackIndex);
            stackValue.setState(taint.getState());
            for (Location location : taint.getTaintedLocations()) {
                stackValue.addTaintLocation(location, true);
            }
            for (Location location : taint.getPossibleTaintedLocations()) {
                stackValue.addTaintLocation(location, false);
            }
            if (stackValue.hasValidLocalVariableIndex()) {
                int index = stackValue.getLocalVariableIndex();
                ((TaintFrame)this.getFrame()).setValue(index, taint);
            }
        }
        catch (DataflowAnalysisException ex) {
            throw new RuntimeException("Bad mutable stack index specification", ex);
        }
    }

    private void pushSafe() {
        ((TaintFrame)this.getFrame()).pushValue(new Taint(Taint.State.SAFE));
    }
}

