/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class TaintMethodSummary {
    private Collection<Integer> transferParameters = null;
    private Taint outputTaint = null;
    private static final int INVALID_INDEX = -1;
    private int mutableStackIndex = -1;
    private static final TaintMethodSummary defaultToStringSummary = new TaintMethodSummary();

    public Collection<Integer> getTransferParameters() {
        if (!this.hasTransferParameters()) {
            throw new IllegalStateException("transfer parameters not set");
        }
        return this.transferParameters;
    }

    public boolean hasTransferParameters() {
        return this.transferParameters != null && !this.transferParameters.isEmpty();
    }

    public void setTransferParameters(Collection<Integer> transferParameters) {
        this.transferParameters = transferParameters;
    }

    public int getMutableStackIndex() {
        if (!this.hasMutableStackIndex()) {
            throw new IllegalStateException("stack index not set");
        }
        return this.mutableStackIndex;
    }

    public boolean hasMutableStackIndex() {
        return this.mutableStackIndex != -1;
    }

    public void setMutableStackIndex(int mutableStackIndex) {
        this.mutableStackIndex = mutableStackIndex;
    }

    public Taint getOutputTaint() {
        if (!this.hasConstantOutputTaint()) {
            throw new IllegalStateException("output taint is not set");
        }
        return this.outputTaint;
    }

    public boolean hasConstantOutputTaint() {
        return this.outputTaint != null;
    }

    public void setOuputTaint(Taint outputTaint) {
        this.outputTaint = outputTaint;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasConstantOutputTaint()) {
            sb.append(this.outputTaint.getState().name());
        } else if (this.hasTransferParameters()) {
            int count = this.transferParameters.size();
            Integer[] array = this.transferParameters.toArray(new Integer[count]);
            sb.append(array[0]);
            for (int i = 1; i < count; ++i) {
                sb.append(",");
                sb.append(array[i]);
            }
        } else {
            throw new IllegalStateException("output taint nor parameters not set");
        }
        if (this.hasMutableStackIndex()) {
            sb.append("#");
            sb.append(this.mutableStackIndex);
        }
        return sb.toString();
    }

    public static TaintMethodSummary getDefaultToStringSummary() {
        return defaultToStringSummary;
    }

    public static TaintMethodSummary load(String str) throws IOException {
        str = str.trim();
        String[] tuple = str.split("#");
        TaintMethodSummary summary = new TaintMethodSummary();
        if (tuple.length == 2) {
            str = tuple[0];
            try {
                summary.setMutableStackIndex(Integer.parseInt(tuple[1]));
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot parse mutable stack offset", ex);
            }
        } else if (tuple.length != 1) {
            throw new IOException("Bad format: only one '#' expected");
        }
        if (str.isEmpty()) {
            throw new IOException("No taint information set");
        }
        if (TaintMethodSummary.isTaintStateValue(str)) {
            summary.setOuputTaint(new Taint(Taint.State.valueOf(str)));
        } else {
            tuple = str.split(",");
            int count = tuple.length;
            ArrayList<Integer> parameters = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                try {
                    parameters.add(Integer.parseInt(tuple[i].trim()));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Cannot parse parameter offset " + i, ex);
                }
            }
            summary.setTransferParameters(parameters);
        }
        return summary;
    }

    private static boolean isTaintStateValue(String value) {
        Taint.State[] states;
        for (Taint.State state : states = Taint.State.values()) {
            if (!state.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<Integer> params = new ArrayList<Integer>(1);
        params.add(0);
        defaultToStringSummary.setTransferParameters(params);
    }
}

