/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.injection.AbstractInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class BasicInjectionDetector
extends AbstractInjectionDetector {
    private final Map<String, InjectionPoint> injectionMap = new HashMap<String, InjectionPoint>();

    public BasicInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        InjectionPoint injectionPoint = this.injectionMap.get(this.getFullMethodName(invoke, cpg));
        if (injectionPoint == null) {
            return InjectionPoint.NONE;
        }
        return injectionPoint;
    }

    protected void addSink(String fullMethodName, int[] injectableParameters, String bugType) {
        int slashIndex;
        assert (fullMethodName != null && !fullMethodName.isEmpty());
        assert (injectableParameters != null && injectableParameters.length != 0);
        assert (!this.injectionMap.containsKey(fullMethodName));
        InjectionPoint injectionPoint = new InjectionPoint(injectableParameters, bugType);
        String classAndMethodName = fullMethodName.substring(0, fullMethodName.indexOf(40));
        String shortName = classAndMethodName.substring((slashIndex = classAndMethodName.lastIndexOf(47)) + 1);
        if (shortName.endsWith("<init>")) {
            shortName = shortName.substring(0, shortName.indexOf(46));
        }
        injectionPoint.setInjectableMethod(shortName.concat("(...)"));
        this.injectionMap.put(fullMethodName, injectionPoint);
    }

    private String getFullMethodName(InvokeInstruction invoke, ConstantPoolGen cpg) {
        return ClassName.toSlashedClassName((String)invoke.getReferenceType(cpg).toString()) + "." + invoke.getMethodName(cpg) + invoke.getSignature(cpg);
    }
}

