/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Inbox;
import com.hazelcast.jet.Outbox;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class AbstractProcessor
implements Processor {
    private Outbox outbox;
    private Object pendingItem;
    private ILogger logger;
    private boolean isCooperative = true;

    public final void setCooperative(boolean isCooperative) {
        this.isCooperative = isCooperative;
    }

    @Override
    public boolean isCooperative() {
        return this.isCooperative;
    }

    @Override
    public final void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.outbox = outbox;
        this.logger = context.logger();
        try {
            this.init(context);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    protected void init(@Nonnull Processor.Context context) throws Exception {
    }

    protected final ILogger getLogger() {
        return this.logger;
    }

    @Override
    public final void process(int ordinal, @Nonnull Inbox inbox) {
        try {
            switch (ordinal) {
                case 0: {
                    this.process0(inbox);
                    return;
                }
                case 1: {
                    this.process1(inbox);
                    return;
                }
                case 2: {
                    this.process2(inbox);
                    return;
                }
                case 3: {
                    this.process3(inbox);
                    return;
                }
                case 4: {
                    this.process4(inbox);
                    return;
                }
            }
            this.processAny(ordinal, inbox);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        throw new UnsupportedOperationException("Missing implementation");
    }

    protected boolean tryProcess0(@Nonnull Object item) throws Exception {
        return this.tryProcess(0, item);
    }

    protected boolean tryProcess1(@Nonnull Object item) throws Exception {
        return this.tryProcess(1, item);
    }

    protected boolean tryProcess2(@Nonnull Object item) throws Exception {
        return this.tryProcess(2, item);
    }

    protected boolean tryProcess3(@Nonnull Object item) throws Exception {
        return this.tryProcess(3, item);
    }

    protected boolean tryProcess4(@Nonnull Object item) throws Exception {
        return this.tryProcess(4, item);
    }

    protected final Outbox getOutbox() {
        return this.outbox;
    }

    protected void emit(int ordinal, @Nonnull Object item) {
        this.outbox.add(ordinal, item);
    }

    protected void emit(@Nonnull Object item) {
        this.outbox.add(item);
    }

    protected boolean emitCooperatively(int ordinal, @Nonnull Traverser<?> traverser) {
        Object item;
        if (this.pendingItem != null) {
            item = this.pendingItem;
            this.pendingItem = null;
        } else {
            item = traverser.next();
        }
        while (item != null) {
            if (this.outbox.isHighWater(ordinal)) {
                this.pendingItem = item;
                return false;
            }
            this.emit(ordinal, item);
            item = traverser.next();
        }
        return true;
    }

    protected boolean emitCooperatively(@Nonnull Traverser<?> traverser) {
        return this.emitCooperatively(-1, traverser);
    }

    @Nonnull
    protected <T, R> FlatMapper<T, R> flatMapper(int outputOrdinal, @Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return new FlatMapper(outputOrdinal, mapper);
    }

    @Nonnull
    protected <T, R> FlatMapper<T, R> flatMapper(@Nonnull Function<? super T, ? extends Traverser<? extends R>> mapper) {
        return this.flatMapper(-1, mapper);
    }

    private void process0(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            if (!this.tryProcess0(item)) {
                return;
            }
            inbox.remove();
        }
    }

    private void process1(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            if (!this.tryProcess1(item)) {
                return;
            }
            inbox.remove();
        }
    }

    private void process2(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            if (!this.tryProcess2(item)) {
                return;
            }
            inbox.remove();
        }
    }

    private void process3(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            if (!this.tryProcess3(item)) {
                return;
            }
            inbox.remove();
        }
    }

    private void process4(@Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            if (!this.tryProcess4(item)) {
                return;
            }
            inbox.remove();
        }
    }

    private void processAny(int ordinal, @Nonnull Inbox inbox) throws Exception {
        Object item;
        while ((item = inbox.peek()) != null) {
            if (!this.tryProcess(ordinal, item)) {
                return;
            }
            inbox.remove();
        }
    }

    protected final class FlatMapper<T, R> {
        private final int outputOrdinal;
        private final Function<? super T, ? extends Traverser<? extends R>> mapper;
        private Traverser<? extends R> outputTraverser;

        FlatMapper(@Nonnull int outputOrdinal, Function<? super T, ? extends Traverser<? extends R>> mapper) {
            this.outputOrdinal = outputOrdinal;
            this.mapper = mapper;
        }

        public boolean tryProcess(@Nonnull T item) {
            if (this.outputTraverser == null) {
                this.outputTraverser = this.mapper.apply(item);
            }
            if (AbstractProcessor.this.emitCooperatively(this.outputOrdinal, this.outputTraverser)) {
                this.outputTraverser = null;
                return true;
            }
            return false;
        }
    }
}

