/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.DefaultPartitionStrategy;
import java.io.Serializable;

@FunctionalInterface
public interface Partitioner<T>
extends Serializable {
    public static final Partitioner<Object> HASH_CODE = (item, partitionCount) -> Math.abs(item.hashCode() % partitionCount);

    default public void init(DefaultPartitionStrategy strat) {
    }

    public int getPartition(T var1, int var2);

    public static Partitioner<Object> defaultPartitioner() {
        return new Default();
    }

    public static final class Default
    implements Partitioner<Object> {
        private static final long serialVersionUID = 1L;
        transient DefaultPartitionStrategy defaultPartitioning;

        Default() {
        }

        @Override
        public void init(DefaultPartitionStrategy defaultPartitioning) {
            this.defaultPartitioning = defaultPartitioning;
        }

        @Override
        public int getPartition(Object item, int partitionCount) {
            return this.defaultPartitioning.getPartition(item);
        }
    }
}

