/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.JetExecuteJobCodec;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.Node;
import com.hazelcast.jet.DAG;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.client.AbstractJetMessageTask;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.operation.ExecuteJobOperation;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;

public class JetExecuteJobMessageTask
extends AbstractJetMessageTask<JetExecuteJobCodec.RequestParameters> {
    protected JetExecuteJobMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection, JetExecuteJobCodec::decodeRequest, o -> JetExecuteJobCodec.encodeResponse());
    }

    protected Operation prepareOperation() {
        JetService service = (JetService)this.getService("hz:impl:jetService");
        ClassLoader cl = service.getClassLoader(((JetExecuteJobCodec.RequestParameters)this.parameters).executionId);
        DAG dag = (DAG)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.nodeEngine.getSerializationService(), cl, ((JetExecuteJobCodec.RequestParameters)this.parameters).dag);
        return new ExecuteJobOperation(((JetExecuteJobCodec.RequestParameters)this.parameters).executionId, dag);
    }

    protected void processMessage() {
        Operation op = this.prepareOperation();
        op.setCallerUuid(this.getEndpoint().getUuid());
        InvocationBuilder builder = this.getInvocationBuilder(op).setResultDeserialized(false);
        InternalCompletableFuture invocation = builder.invoke();
        this.getJetService().getClientInvocationRegistry().register(((JetExecuteJobCodec.RequestParameters)this.parameters).executionId, (ICompletableFuture<Object>)invocation);
        invocation.andThen((ExecutionCallback)this);
    }

    public String getMethodName() {
        return "execute";
    }

    public Object[] getParameters() {
        return new Object[]{((JetExecuteJobCodec.RequestParameters)this.parameters).dag};
    }

    public void onResponse(Object response) {
        super.onResponse(response);
    }

    public void onFailure(Throwable t) {
        super.onFailure(t);
    }
}

