/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.Inbox;
import com.hazelcast.jet.Processor;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.SerializableClientConfig;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class WriteIMapP
implements Processor {
    private final IMap map;
    private final ArrayMap buffer = new ArrayMap();

    private WriteIMapP(IMap map) {
        this.map = map;
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        inbox.drainTo(this.buffer.entries);
        this.flush();
    }

    @Override
    public boolean complete() {
        this.flush();
        return true;
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    private void flush() {
        this.map.putAll((Map)this.buffer);
        this.buffer.clear();
    }

    public static ProcessorMetaSupplier supplier(String mapName) {
        return ProcessorMetaSupplier.of(new Supplier(mapName));
    }

    public static ProcessorMetaSupplier supplier(String mapName, ClientConfig clientConfig) {
        SerializableClientConfig config = clientConfig != null ? new SerializableClientConfig(clientConfig) : null;
        return ProcessorMetaSupplier.of(new Supplier(mapName, config));
    }

    private static class ArrayMap
    extends AbstractMap {
        private final List<Map.Entry> entries;
        private final ArraySet set = new ArraySet();

        ArrayMap() {
            this.entries = new ArrayList<Map.Entry>();
        }

        @Override
        @Nonnull
        public Set<Map.Entry> entrySet() {
            return this.set;
        }

        public void add(Map.Entry entry) {
            this.entries.add(entry);
        }

        private class ArraySet
        extends AbstractSet<Map.Entry> {
            private ArraySet() {
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry> iterator() {
                return ArrayMap.this.entries.iterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.entries.size();
            }
        }
    }

    private static class Supplier
    implements ProcessorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;
        private final SerializableClientConfig clientConfig;
        private transient IMap map;
        private transient HazelcastInstance client;

        Supplier(String name, SerializableClientConfig clientConfig) {
            this.name = name;
            this.clientConfig = clientConfig;
        }

        Supplier(String name) {
            this(name, null);
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context context) {
            HazelcastInstance instance = this.isRemote() ? (this.client = HazelcastClient.newHazelcastClient((ClientConfig)this.clientConfig.asClientConfig())) : context.jetInstance().getHazelcastInstance();
            this.map = instance.getMap(this.name);
        }

        @Override
        public void complete(Throwable error) {
            if (this.client != null) {
                this.client.shutdown();
            }
        }

        private boolean isRemote() {
            return this.clientConfig != null;
        }

        @Nonnull
        public List<Processor> get(int count) {
            return Stream.generate(() -> new WriteIMapP(this.map)).limit(count).collect(Collectors.toList());
        }
    }
}

