/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.ExecutionService;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.spi.NodeEngine;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public class ExecutionContext {
    private Map<Integer, Map<Integer, ReceiverTasklet>> receiverMap = Collections.emptyMap();
    private Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = Collections.emptyMap();
    private List<ProcessorSupplier> procSuppliers = Collections.emptyList();
    private Map<Address, Integer> memberToId = Collections.emptyMap();
    private List<Tasklet> tasklets;
    private CompletionStage<Void> executionCompletionStage;
    private final long executionId;
    private final NodeEngine nodeEngine;
    private final ExecutionService execService;

    public ExecutionContext(long executionId, NodeEngine nodeEngine, ExecutionService execService) {
        this.executionId = executionId;
        this.execService = execService;
        this.nodeEngine = nodeEngine;
    }

    public CompletionStage<Void> execute(Consumer<CompletionStage<Void>> doneCallback) {
        this.executionCompletionStage = this.execService.execute(this.tasklets, doneCallback);
        this.executionCompletionStage.whenComplete((r, e) -> this.tasklets.clear());
        return this.executionCompletionStage;
    }

    public CompletionStage<Void> getExecutionCompletionStage() {
        return this.executionCompletionStage;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap() {
        return this.senderMap;
    }

    public Map<Integer, Map<Integer, ReceiverTasklet>> receiverMap() {
        return this.receiverMap;
    }

    public void complete(Throwable error) {
        this.procSuppliers.forEach(s -> s.complete(error));
    }

    public void handlePacket(int vertexId, int ordinal, Address sender, BufferObjectDataInput in) {
        this.receiverMap.get(vertexId).get(ordinal).receiveStreamPacket(in, this.memberToId.get(sender));
    }

    public Integer getMemberId(Address member) {
        return this.memberToId != null ? this.memberToId.get(member) : null;
    }

    public ExecutionContext initialize(ExecutionPlan plan) {
        this.populateMemberToId();
        this.procSuppliers = Collections.unmodifiableList(plan.getProcessorSuppliers());
        plan.initialize(this.nodeEngine, this.executionId);
        this.receiverMap = Collections.unmodifiableMap(plan.getReceiverMap());
        this.senderMap = Collections.unmodifiableMap(plan.getSenderMap());
        this.tasklets = plan.getTasklets();
        return this;
    }

    private void populateMemberToId() {
        HashMap<Address, Integer> memberToId = new HashMap<Address, Integer>();
        int id = 0;
        for (Address member : Util.getRemoteMembers(this.nodeEngine)) {
            memberToId.put(member, id++);
        }
        this.memberToId = Collections.unmodifiableMap(memberToId);
    }
}

