/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.function.Supplier;

class InitOperation
extends Operation {
    private long executionId;
    private Supplier<ExecutionPlan> planSupplier;

    InitOperation(long executionId, ExecutionPlan plan) {
        this.executionId = executionId;
        this.planSupplier = () -> plan;
    }

    private InitOperation() {
    }

    public void run() throws Exception {
        this.getLogger().info("Initializing execution plan for job " + this.executionId + " from " + this.getCallerAddress() + ".");
        JetService service = (JetService)this.getService();
        service.initExecution(this.executionId, this.planSupplier.get());
        this.getLogger().fine("Execution plan for job " + this.executionId + " initialized.");
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        Data planBlob = this.getNodeEngine().getSerializationService().toData((Object)this.planSupplier.get());
        out.writeData(planBlob);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        Data planBlob = in.readData();
        this.planSupplier = () -> {
            JetService service = (JetService)this.getService();
            ClassLoader cl = service.getClassLoader(this.executionId);
            return (ExecutionPlan)CustomClassLoadedObject.deserializeWithCustomClassLoader(this.getNodeEngine().getSerializationService(), cl, planBlob);
        };
    }
}

