/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.jet.Outbox;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import javax.annotation.Nonnull;

public final class ArrayDequeOutbox
implements Outbox {
    private final ArrayDeque<Object>[] buckets;
    private final int[] highWaterMarks;

    public ArrayDequeOutbox(int size, int[] highWaterMarks) {
        this.highWaterMarks = (int[])highWaterMarks.clone();
        this.buckets = new ArrayDeque[size];
        Arrays.setAll(this.buckets, i -> new ArrayDeque());
    }

    @Override
    public int bucketCount() {
        return this.buckets.length;
    }

    @Override
    public void add(int ordinal, @Nonnull Object item) {
        if (ordinal != -1) {
            this.buckets[ordinal].add(item);
        } else {
            for (ArrayDeque<Object> queue : this.buckets) {
                queue.add(item);
            }
        }
    }

    @Override
    public boolean isHighWater(int ordinal) {
        if (ordinal != -1) {
            return this.buckets[ordinal].size() >= this.highWaterMarks[ordinal];
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i].size() < this.highWaterMarks[i]) continue;
            return true;
        }
        return false;
    }

    public Queue<Object> queueWithOrdinal(int ordinal) {
        return this.buckets[ordinal];
    }
}

