/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.server;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.nio.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public final class StartServer {
    private StartServer() {
    }

    public static void main(String[] args) throws Exception {
        JetInstance jet = Jet.newJetInstance();
        StartServer.printMemberPort(jet.getHazelcastInstance());
    }

    private static void printMemberPort(HazelcastInstance hz) throws FileNotFoundException, UnsupportedEncodingException {
        String printPort = System.getProperty("print.port");
        if (printPort != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter("ports" + File.separator + printPort, "UTF-8");
                printWriter.println(hz.getCluster().getLocalMember().getAddress().getPort());
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(printWriter);
                throw throwable;
            }
            IOUtil.closeResource((Closeable)printWriter);
        }
    }
}

