/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream;

import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.DistributedDoubleStream;
import com.hazelcast.jet.stream.DistributedIntStream;
import com.hazelcast.jet.stream.DistributedLongStream;
import com.hazelcast.jet.stream.impl.reducers.CollectorReducer;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface DistributedStream<T>
extends Stream<T> {
    @Override
    default public DistributedStream<T> filter(Distributed.Predicate<? super T> predicate) {
        return this.filter((Predicate)predicate);
    }

    @Override
    default public <R> DistributedStream<R> map(Distributed.Function<? super T, ? extends R> mapper) {
        return this.map((Function)mapper);
    }

    default public DistributedIntStream mapToInt(Distributed.ToIntFunction<? super T> mapper) {
        return this.mapToInt((ToIntFunction)mapper);
    }

    default public DistributedLongStream mapToLong(Distributed.ToLongFunction<? super T> mapper) {
        return this.mapToLong((ToLongFunction)mapper);
    }

    default public DistributedDoubleStream mapToDouble(Distributed.ToDoubleFunction<? super T> mapper) {
        return this.mapToDouble((ToDoubleFunction)mapper);
    }

    @Override
    default public <R> DistributedStream<R> flatMap(Distributed.Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.flatMap((Function)mapper);
    }

    default public DistributedIntStream flatMapToInt(Distributed.Function<? super T, ? extends IntStream> mapper) {
        return this.flatMapToInt((Function)mapper);
    }

    default public DistributedLongStream flatMapToLong(Distributed.Function<? super T, ? extends LongStream> mapper) {
        return this.flatMapToLong((Function)mapper);
    }

    default public DistributedDoubleStream flatMapToDouble(Distributed.Function<? super T, ? extends DoubleStream> mapper) {
        return this.flatMapToDouble((Function)mapper);
    }

    @Override
    public DistributedStream<T> distinct();

    @Override
    public DistributedStream<T> sorted();

    @Override
    default public DistributedStream<T> sorted(Distributed.Comparator<? super T> comparator) {
        return this.sorted((Comparator)comparator);
    }

    @Override
    default public DistributedStream<T> peek(Distributed.Consumer<? super T> action) {
        return this.peek((Consumer)action);
    }

    @Override
    public DistributedStream<T> limit(long var1);

    @Override
    public DistributedStream<T> skip(long var1);

    @Override
    default public T reduce(T identity, Distributed.BinaryOperator<T> accumulator) {
        return this.reduce(identity, (BinaryOperator<T>)accumulator);
    }

    @Override
    default public Optional<T> reduce(Distributed.BinaryOperator<T> accumulator) {
        return this.reduce((BinaryOperator<T>)accumulator);
    }

    @Override
    default public <U> U reduce(U identity, Distributed.BiFunction<U, ? super T, U> accumulator, Distributed.BinaryOperator<U> combiner) {
        return this.reduce(identity, (BiFunction<U, ? super T, U>)accumulator, (BinaryOperator<U>)combiner);
    }

    @Override
    default public <R> R collect(Distributed.Supplier<R> supplier, Distributed.BiConsumer<R, ? super T> accumulator, Distributed.BiConsumer<R, R> combiner) {
        return this.collect((Supplier<R>)supplier, (BiConsumer<R, ? super T>)accumulator, (BiConsumer<R, R>)combiner);
    }

    @Override
    default public <R, A> R collect(DistributedCollector<? super T, A, R> collector) {
        return this.collect(new CollectorReducer(collector.supplier(), collector.accumulator(), collector.combiner(), collector.finisher()));
    }

    public <R> R collect(DistributedCollector.Reducer<? super T, R> var1);

    @Override
    default public Optional<T> min(Distributed.Comparator<? super T> comparator) {
        return this.min((Comparator<? super T>)comparator);
    }

    @Override
    default public Optional<T> max(Distributed.Comparator<? super T> comparator) {
        return this.max((Comparator<? super T>)comparator);
    }

    @Override
    default public boolean anyMatch(Distributed.Predicate<? super T> predicate) {
        return this.anyMatch((Predicate<? super T>)predicate);
    }

    @Override
    default public boolean allMatch(Distributed.Predicate<? super T> predicate) {
        return this.allMatch((Predicate<? super T>)predicate);
    }

    @Override
    default public boolean noneMatch(Distributed.Predicate<? super T> predicate) {
        return this.noneMatch((Predicate<? super T>)predicate);
    }

    @Override
    public DistributedStream<T> sequential();

    @Override
    public DistributedStream<T> parallel();

    @Override
    public DistributedStream<T> unordered();

    @Override
    public DistributedStream<T> filter(Predicate<? super T> var1);

    @Override
    public <R> DistributedStream<R> map(Function<? super T, ? extends R> var1);

    @Override
    public DistributedIntStream mapToInt(ToIntFunction<? super T> var1);

    @Override
    public DistributedLongStream mapToLong(ToLongFunction<? super T> var1);

    @Override
    public DistributedDoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    @Override
    public <R> DistributedStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> var1);

    @Override
    public DistributedIntStream flatMapToInt(Function<? super T, ? extends IntStream> var1);

    @Override
    public DistributedLongStream flatMapToLong(Function<? super T, ? extends LongStream> var1);

    @Override
    public DistributedDoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> var1);

    @Override
    public DistributedStream<T> sorted(Comparator<? super T> var1);

    @Override
    public DistributedStream<T> peek(Consumer<? super T> var1);

    @Override
    public T reduce(T var1, BinaryOperator<T> var2);

    @Override
    public Optional<T> reduce(BinaryOperator<T> var1);

    @Override
    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    @Override
    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    @Override
    public Optional<T> min(Comparator<? super T> var1);

    @Override
    public Optional<T> max(Comparator<? super T> var1);

    @Override
    public boolean anyMatch(Predicate<? super T> var1);

    @Override
    public boolean allMatch(Predicate<? super T> var1);

    @Override
    public boolean noneMatch(Predicate<? super T> var1);
}

