/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.TransformP;
import java.util.stream.Stream;

class TransformPipeline<E_IN, E_OUT>
extends AbstractIntermediatePipeline<E_IN, E_OUT> {
    private final Distributed.Function<Traverser<E_IN>, Traverser<E_OUT>> transformer;

    TransformPipeline(StreamContext context, Pipeline<E_IN> upstream, Distributed.Function<Traverser<E_IN>, Traverser<E_OUT>> transformer) {
        super(context, upstream.isOrdered(), upstream);
        this.transformer = transformer;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        Distributed.Function transformer = this.transformer;
        Vertex transform = dag.newVertex(StreamUtil.uniqueVertexName("transform"), () -> new TransformP(transformer));
        if (this.upstream.isOrdered()) {
            transform.localParallelism(1);
        }
        dag.edge(Edge.between(previous, transform));
        return transform;
    }

    @Override
    public DistributedStream<E_OUT> filter(Distributed.Predicate<? super E_OUT> predicate) {
        Distributed.Function transformer = this.transformer;
        return new TransformPipeline<E_IN, E_OUT>(this.context, this.upstream, t -> ((Traverser)transformer.apply((Traverser)t)).filter(predicate));
    }

    @Override
    public <R> DistributedStream<R> map(Distributed.Function<? super E_OUT, ? extends R> mapper) {
        Distributed.Function transformer = this.transformer;
        return new TransformPipeline<E_IN, E_OUT>(this.context, this.upstream, t -> ((Traverser)transformer.apply((Traverser)t)).map(mapper));
    }

    @Override
    public <R> DistributedStream<R> flatMap(Distributed.Function<? super E_OUT, ? extends Stream<? extends R>> mapper) {
        Distributed.Function transformer = this.transformer;
        return new TransformPipeline<E_IN, E_OUT>(this.context, this.upstream, t -> ((Traverser)transformer.apply((Traverser)t)).flatMap((? super T item) -> Traversers.traverseStream((Stream)mapper.apply((Object)item))));
    }
}

