/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.core.IList;
import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Processors;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.DistributedCollector;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.AnyMatchP;
import java.util.function.Predicate;

public class AnyMatchReducer<T>
implements DistributedCollector.Reducer<T, Boolean> {
    private final Predicate<? super T> predicate;

    public AnyMatchReducer(Predicate<? super T> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Boolean reduce(StreamContext context, Pipeline<? extends T> upstream) {
        String listName = StreamUtil.uniqueListName();
        DAG dag = new DAG();
        Vertex previous = upstream.buildDAG(dag);
        Vertex anyMatch = dag.newVertex("any-match", () -> new AnyMatchP(this.predicate));
        Vertex writer = dag.newVertex("write-" + listName, Processors.writeList(listName));
        dag.edge(Edge.between(previous, anyMatch)).edge(Edge.between(anyMatch, writer));
        StreamUtil.executeJob(context, dag);
        IStreamList<Boolean> results = context.getJetInstance().getList(listName);
        boolean result = AnyMatchReducer.anyMatch(results);
        results.destroy();
        return result;
    }

    private static boolean anyMatch(IList<Boolean> results) {
        for (Boolean result : results) {
            if (!result.booleanValue()) continue;
            return true;
        }
        return false;
    }
}

