/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.Processors;
import com.hazelcast.jet.stream.IStreamList;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.reducers.AbstractSinkReducer;

public class IListReducer<T>
extends AbstractSinkReducer<T, IStreamList<T>> {
    private final String listName;

    public IListReducer() {
        this(StreamUtil.uniqueListName());
    }

    private IListReducer(String listName) {
        this.listName = listName;
    }

    @Override
    protected IStreamList<T> getTarget(JetInstance instance) {
        return instance.getList(this.listName);
    }

    @Override
    protected ProcessorMetaSupplier getSupplier() {
        return ProcessorMetaSupplier.of(Processors.writeList(this.listName));
    }

    @Override
    protected int localParallelism() {
        return 1;
    }

    @Override
    protected String getName() {
        return this.listName;
    }
}

