/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.reducers;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.ProcessorMetaSupplier;
import com.hazelcast.jet.Processors;
import com.hazelcast.jet.stream.IStreamMap;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.reducers.AbstractSinkReducer;
import java.util.function.Function;

public class IMapReducer<T, K, V>
extends AbstractSinkReducer<T, IStreamMap<K, V>> {
    final String mapName;
    final Function<? super T, ? extends K> keyMapper;
    final Function<? super T, ? extends V> valueMapper;

    public IMapReducer(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        this(StreamUtil.uniqueMapName(), keyMapper, valueMapper);
    }

    IMapReducer(String mapName, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        this.mapName = mapName;
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    @Override
    protected IStreamMap<K, V> getTarget(JetInstance instance) {
        return instance.getMap(this.mapName);
    }

    @Override
    protected ProcessorMetaSupplier getSupplier() {
        return Processors.writeMap(this.mapName);
    }

    @Override
    protected int localParallelism() {
        return -1;
    }

    @Override
    protected String getName() {
        return this.mapName;
    }
}

