/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.deployment.ResourceKind;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class JobConfig
implements Serializable {
    private static final int DEFAULT_RESOURCE_PART_SIZE = 16384;
    private final Set<ResourceConfig> resourceConfigs = new HashSet<ResourceConfig>();
    private final Properties properties = new Properties();

    public Properties getProperties() {
        return this.properties;
    }

    public int getResourcePartSize() {
        return 16384;
    }

    public void addClass(Class ... classes) {
        Preconditions.checkNotNull((Object)classes, (String)"Classes can not be null");
        for (Class clazz : classes) {
            this.resourceConfigs.add(new ResourceConfig(clazz));
        }
    }

    public void addJar(URL url) {
        this.addJar(url, this.getFileName(url));
    }

    public void addJar(URL url, String id) {
        this.add(url, id, ResourceKind.JAR);
    }

    public void addJar(File file) {
        try {
            this.addJar(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void addJar(File file, String id) {
        try {
            this.addJar(file.toURI().toURL(), id);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void addJar(String path) {
        try {
            File file = new File(path);
            this.addJar(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void addJar(String path, String id) {
        try {
            this.addJar(new File(path).toURI().toURL(), id);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void addResource(URL url) {
        this.addResource(url, this.getFileName(url));
    }

    public void addResource(URL url, String id) {
        this.add(url, id, ResourceKind.DATA);
    }

    public void addResource(File file) {
        try {
            this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void addResource(File file, String id) {
        try {
            this.add(file.toURI().toURL(), id, ResourceKind.DATA);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void addResource(String path) {
        File file = new File(path);
        try {
            this.addResource(file.toURI().toURL(), file.getName());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void addResource(String path, String id) {
        File file = new File(path);
        try {
            this.addResource(file.toURI().toURL(), id);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public Set<ResourceConfig> getResourceConfigs() {
        return this.resourceConfigs;
    }

    private void add(URL url, String id, ResourceKind type) {
        this.resourceConfigs.add(new ResourceConfig(url, id, type));
    }

    private String getFileName(URL url) {
        String urlFile = url.getFile();
        return urlFile.substring(urlFile.lastIndexOf(47) + 1, urlFile.length());
    }
}

