/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.jet.impl.execution.init.MemoizingSupplier;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.NodeEngine;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class PartitionArrangement {
    final Supplier<Map<Address, int[]>> remotePartitionAssignment;
    private final Supplier<int[]> localPartitions = MemoizingSupplier.memoize(() -> PartitionArrangement.arrangeLocalPartitions(nodeEngine));
    private final Supplier<int[]> allPartitions = MemoizingSupplier.memoize(() -> PartitionArrangement.arrangeAllPartitions(nodeEngine, this.localPartitions.get()));

    PartitionArrangement(NodeEngine nodeEngine) {
        this.remotePartitionAssignment = MemoizingSupplier.memoize(() -> PartitionArrangement.remotePartitionAssignment(nodeEngine));
    }

    int[][] assignPartitionsToProcessors(int processorCount, boolean isEdgeDistributed) {
        int[] arrangedPtions = (isEdgeDistributed ? this.localPartitions : this.allPartitions).get();
        int[][] ptionsPerProcessor = PartitionArrangement.createPtionArrays(arrangedPtions.length, processorCount);
        int majorIndex = 0;
        int minorIndex = 0;
        int[] nArray = arrangedPtions;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int ptionId;
            ptionsPerProcessor[majorIndex][minorIndex] = ptionId = nArray[i];
            if (++majorIndex != processorCount) continue;
            majorIndex = 0;
            ++minorIndex;
        }
        return ptionsPerProcessor;
    }

    private static int[] arrangeLocalPartitions(NodeEngine nodeEngine) {
        return nodeEngine.getPartitionService().getMemberPartitions(nodeEngine.getThisAddress()).stream().mapToInt(x -> x).sorted().toArray();
    }

    private static int[] arrangeAllPartitions(NodeEngine nodeEngine, int[] localPartitions) {
        int totalPartitionCount = nodeEngine.getPartitionService().getPartitionCount();
        int[] allPartitions = Arrays.copyOf(localPartitions, totalPartitionCount);
        int i = localPartitions.length;
        for (int ption = 0; ption < totalPartitionCount; ++ption) {
            if (Arrays.binarySearch(localPartitions, ption) >= 0) continue;
            allPartitions[i++] = ption;
        }
        return allPartitions;
    }

    private static int[][] createPtionArrays(int ptionCount, int processorCount) {
        int[][] ptionsPerProcessor = new int[processorCount][];
        int quot = ptionCount / processorCount;
        int rem = ptionCount % processorCount;
        Arrays.setAll(ptionsPerProcessor, i -> new int[quot + (i < rem ? 1 : 0)]);
        return ptionsPerProcessor;
    }

    private static Map<Address, int[]> remotePartitionAssignment(NodeEngine nodeEngine) {
        Address localAddress = nodeEngine.getThisAddress();
        Map partitionOwnerMap = nodeEngine.getPartitionService().getMemberPartitionsMap();
        Map<Address, List> addrToPartitions = partitionOwnerMap.entrySet().stream().filter(e -> !((Address)e.getKey()).equals((Object)localAddress)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return addrToPartitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().mapToInt(x -> x).toArray()));
    }
}

