/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import java.util.List;
import java.util.RandomAccess;

public class CircularListCursor<E> {
    private int index;
    private final List<E> list;

    public CircularListCursor(List<E> list) {
        assert (list instanceof RandomAccess) : "Attempt to create CircularListCursor with non-RandomAccess list";
        this.list = list;
    }

    public boolean advance() {
        if (this.list.isEmpty()) {
            return false;
        }
        if (++this.index >= this.list.size()) {
            this.index = 0;
        }
        return true;
    }

    public E value() {
        return this.list.get(this.index);
    }

    public void reset() {
        this.index = 0;
    }

    public void remove() {
        this.list.remove(this.index--);
        if (this.index < 0) {
            this.index = this.list.size() - 1;
        }
    }

    public String toString() {
        return "ListCursor{index=" + this.index + '}';
    }
}

