/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;

public final class StreamUtil {
    private static final String MAP_PREFIX = "__jet_map_";
    private static final String LIST_PREFIX = "__jet_list_";

    private StreamUtil() {
    }

    public static String uniqueListName() {
        return LIST_PREFIX + StreamUtil.randomName();
    }

    public static String uniqueMapName() {
        return MAP_PREFIX + StreamUtil.randomName();
    }

    public static String writerVertexName(String name) {
        return name + "-writer";
    }

    public static String uniqueVertexName(String name) {
        return name + "-" + UuidUtil.newUnsecureUUID().toString();
    }

    public static void executeJob(StreamContext context, DAG dag) {
        Job job = context.getJetInstance().newJob(dag);
        try {
            job.execute().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
        context.getStreamListeners().forEach(Runnable::run);
    }

    public static void setPrivateField(Object instance, Class<?> clazz, String name, Object val) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        field.set(instance, val);
    }

    private static String randomName() {
        return UuidUtil.newUnsecureUUID().toString();
    }

    public static void checkSerializable(Object argument, String argumentName) {
        if (argument != null) {
            if (!(argument instanceof Serializable)) {
                throw new IllegalArgumentException("Argument \"" + argumentName + "\" must be serializable");
            }
            try (ObjectOutputStream os = new ObjectOutputStream(new NullOutputStream());){
                os.writeObject(argument);
            }
            catch (InvalidClassException | NotSerializableException e) {
                throw new IllegalArgumentException("Argument \"" + argumentName + "\" must be serializable", e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

