/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.collectors;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.collectors.AbstractCollector;
import com.hazelcast.jet.stream.impl.collectors.DistributedCollectorImpl;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class CustomStreamCollector<T, R>
extends AbstractCollector<T, R, R> {
    private final Supplier<R> supplier;
    private final BiConsumer<R, ? super T> accumulator;
    private final BiConsumer<R, R> combiner;

    public CustomStreamCollector(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        StreamUtil.checkSerializable(supplier, "supplier");
        StreamUtil.checkSerializable(accumulator, "accumulator");
        StreamUtil.checkSerializable(combiner, "combiner");
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.combiner = combiner;
    }

    @Override
    public R collect(StreamContext context, Pipeline<? extends T> upstream) {
        DAG dag = new DAG();
        Vertex accumulatorVertex = DistributedCollectorImpl.buildAccumulator(dag, upstream, this.supplier, this.accumulator);
        Vertex combinerVertex = DistributedCollectorImpl.buildCombiner(dag, accumulatorVertex, this.combiner, null);
        return DistributedCollectorImpl.execute(context, dag, combinerVertex);
    }
}

