/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.SortP;
import java.util.Comparator;

public class SortPipeline<T>
extends AbstractIntermediatePipeline<T, T> {
    private final Comparator<? super T> comparator;

    public SortPipeline(Pipeline<T> upstream, StreamContext context, Comparator<? super T> comparator) {
        super(context, true, upstream);
        this.comparator = comparator;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        Comparator comparator = this.comparator;
        Vertex sorter = dag.newVertex(StreamUtil.uniqueVertexName("sorter"), () -> new SortP(comparator)).localParallelism(1);
        dag.edge(Edge.between(previous, sorter).distributed().allToOne());
        return sorter;
    }
}

