/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.DAG;
import com.hazelcast.jet.Distributed;
import com.hazelcast.jet.Edge;
import com.hazelcast.jet.Vertex;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipeline;
import com.hazelcast.jet.stream.impl.pipeline.Pipeline;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.pipeline.TransformOperation;
import com.hazelcast.jet.stream.impl.processor.TransformP;
import java.util.ArrayList;
import java.util.List;

public class TransformPipeline
extends AbstractIntermediatePipeline {
    private final List<TransformOperation> operations = new ArrayList<TransformOperation>();

    public TransformPipeline(StreamContext context, Pipeline upstream, TransformOperation operation) {
        super(context, upstream.isOrdered(), upstream);
        this.operations.add(operation);
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        List<TransformOperation> ops = this.operations;
        Vertex transform = dag.newVertex(StreamUtil.uniqueVertexName("transform"), () -> new TransformP(ops));
        if (this.upstream.isOrdered()) {
            transform.localParallelism(1);
        }
        dag.edge(Edge.between(previous, transform));
        return transform;
    }

    @Override
    public DistributedStream filter(Distributed.Predicate predicate) {
        this.operations.add(new TransformOperation(TransformOperation.Type.FILTER, predicate));
        return this;
    }

    @Override
    public DistributedStream map(Distributed.Function mapper) {
        this.operations.add(new TransformOperation(TransformOperation.Type.MAP, mapper));
        return this;
    }

    @Override
    public DistributedStream flatMap(Distributed.Function mapper) {
        this.operations.add(new TransformOperation(TransformOperation.Type.FLAT_MAP, mapper));
        return this;
    }
}

