/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.processor;

import com.hazelcast.jet.AbstractProcessor;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class GroupAndAccumulateP<T, K, V, A, R>
extends AbstractProcessor {
    private final Map<K, A> groups = new HashMap<K, A>();
    private final Function<? super T, ? extends K> classifier;
    private final Collector<V, A, R> collector;
    private final Traverser<Map.Entry<K, A>> resultTraverser;

    public GroupAndAccumulateP(Function<? super T, ? extends K> classifier, Collector<V, A, R> collector) {
        this.classifier = classifier;
        this.collector = collector;
        this.resultTraverser = Traversers.lazy(() -> Traversers.traverseStream(this.groups.entrySet().stream().map(entry -> Util.entry(entry.getKey(), entry.getValue()))));
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        Map.Entry<K, Object> entry = Util.entry(this.classifier.apply(item), item);
        Object value = this.groups.computeIfAbsent(entry.getKey(), k -> this.collector.supplier().get());
        this.collector.accumulator().accept(value, entry.getValue());
        return true;
    }

    @Override
    public boolean complete() {
        return this.emitCooperatively(this.resultTraverser);
    }
}

