/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.util.StringUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class QueryCacheConfigBuilderHelper
extends AbstractXmlConfigHelper {
    QueryCacheConfigBuilderHelper() {
    }

    void handleQueryCache(ClientConfig clientConfig, Node node) {
        for (Node queryCacheNode : QueryCacheConfigBuilderHelper.childElements(node)) {
            if (!"query-cache".equals(QueryCacheConfigBuilderHelper.cleanNodeName(queryCacheNode))) continue;
            NamedNodeMap attrs = queryCacheNode.getAttributes();
            String cacheName = this.getTextContent(attrs.getNamedItem("name"));
            String mapName = this.getTextContent(attrs.getNamedItem("mapName"));
            QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
            for (Node childNode : QueryCacheConfigBuilderHelper.childElements(queryCacheNode)) {
                String textContent = this.getTextContent(childNode);
                String nodeName = QueryCacheConfigBuilderHelper.cleanNodeName(childNode);
                this.populateQueryCacheConfig(queryCacheConfig, childNode, textContent, nodeName);
            }
            clientConfig.addQueryCacheConfig(mapName, queryCacheConfig);
        }
    }

    private void populateQueryCacheConfig(QueryCacheConfig queryCacheConfig, Node childNode, String textContent, String nodeName) {
        if ("entry-listeners".equals(nodeName)) {
            this.handleEntryListeners(queryCacheConfig, childNode);
        } else if ("include-value".equals(nodeName)) {
            boolean includeValue = QueryCacheConfigBuilderHelper.getBooleanValue(textContent);
            queryCacheConfig.setIncludeValue(includeValue);
        } else if ("batch-size".equals(nodeName)) {
            int batchSize = QueryCacheConfigBuilderHelper.getIntegerValue("batch-size", textContent.trim());
            queryCacheConfig.setBatchSize(batchSize);
        } else if ("buffer-size".equals(nodeName)) {
            int bufferSize = QueryCacheConfigBuilderHelper.getIntegerValue("buffer-size", textContent.trim());
            queryCacheConfig.setBufferSize(bufferSize);
        } else if ("delay-seconds".equals(nodeName)) {
            int delaySeconds = QueryCacheConfigBuilderHelper.getIntegerValue("delay-seconds", textContent.trim());
            queryCacheConfig.setDelaySeconds(delaySeconds);
        } else if ("in-memory-format".equals(nodeName)) {
            String value = textContent.trim();
            queryCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
        } else if ("coalesce".equals(nodeName)) {
            boolean coalesce = QueryCacheConfigBuilderHelper.getBooleanValue(textContent);
            queryCacheConfig.setCoalesce(coalesce);
        } else if ("populate".equals(nodeName)) {
            boolean populate = QueryCacheConfigBuilderHelper.getBooleanValue(textContent);
            queryCacheConfig.setPopulate(populate);
        } else if ("indexes".equals(nodeName)) {
            this.queryCacheIndexesHandle(childNode, queryCacheConfig);
        } else if ("predicate".equals(nodeName)) {
            this.queryCachePredicateHandler(childNode, queryCacheConfig);
        } else if ("eviction".equals(nodeName)) {
            queryCacheConfig.setEvictionConfig(this.getEvictionConfig(childNode));
        }
    }

    private EvictionConfig getEvictionConfig(Node node) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size = node.getAttributes().getNamedItem("size");
        Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
        Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        return evictionConfig;
    }

    private void handleEntryListeners(QueryCacheConfig queryCacheConfig, Node childNode) {
        for (Node listenerNode : QueryCacheConfigBuilderHelper.childElements(childNode)) {
            if (!"entry-listener".equals(QueryCacheConfigBuilderHelper.cleanNodeName(listenerNode))) continue;
            NamedNodeMap listenerNodeAttributes = listenerNode.getAttributes();
            boolean incValue = QueryCacheConfigBuilderHelper.getBooleanValue(this.getTextContent(listenerNodeAttributes.getNamedItem("include-value")));
            boolean local = QueryCacheConfigBuilderHelper.getBooleanValue(this.getTextContent(listenerNodeAttributes.getNamedItem("local")));
            String listenerClass = this.getTextContent(listenerNode);
            queryCacheConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    private void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        NamedNodeMap predicateAttributes = childNode.getAttributes();
        String predicateType = this.getTextContent(predicateAttributes.getNamedItem("type"));
        String textContent = this.getTextContent(childNode);
        PredicateConfig predicateConfig = new PredicateConfig();
        if ("class-name".equals(predicateType)) {
            predicateConfig.setClassName(textContent);
        } else if ("sql".equals(predicateType)) {
            predicateConfig.setSql(textContent);
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    private void queryCacheIndexesHandle(Node n, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : QueryCacheConfigBuilderHelper.childElements(n)) {
            if (!"index".equals(QueryCacheConfigBuilderHelper.cleanNodeName(indexNode))) continue;
            NamedNodeMap attrs = indexNode.getAttributes();
            boolean ordered = QueryCacheConfigBuilderHelper.getBooleanValue(this.getTextContent(attrs.getNamedItem("ordered")));
            String attribute = this.getTextContent(indexNode);
            queryCacheConfig.addIndexConfig(new MapIndexConfig(attribute, ordered));
        }
    }
}

