/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembershipManagerCompat;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

@Deprecated
public class MemberRemoveOperation
extends AbstractClusterOperation {
    private Address address;
    private String memberUuid;

    public MemberRemoveOperation() {
    }

    public MemberRemoveOperation(Address address) {
        this.address = address;
    }

    public MemberRemoveOperation(Address address, String uuid) {
        this.address = address;
        this.memberUuid = uuid;
    }

    @Override
    public void run() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Address caller = this.getCallerAddress();
        ILogger logger = this.getLogger();
        if (!this.isCallerValid(caller)) {
            return;
        }
        String msg = "Removing member " + this.address + (this.memberUuid != null ? ", uuid: " + this.memberUuid : "") + ", requested by: " + caller;
        if (logger.isFineEnabled()) {
            logger.fine(msg);
        }
        MembershipManagerCompat membershipManagerCompat = clusterService.getMembershipManagerCompat();
        membershipManagerCompat.removeMember(this.address, this.memberUuid, msg);
    }

    private boolean isCallerValid(Address caller) {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        if (caller == null) {
            if (logger.isFineEnabled()) {
                logger.fine("Ignoring removal request of " + this.address + ", because sender is local or not known.");
            }
            return false;
        }
        if (!this.address.equals(caller) && !caller.equals(clusterService.getMasterAddress())) {
            if (logger.isFineEnabled()) {
                logger.fine("Ignoring removal request of " + this.address + ", because sender is neither dead-member " + "nor master: " + caller);
            }
            return false;
        }
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        this.memberUuid = in.readUTF();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        out.writeUTF(this.memberUuid);
    }

    @Override
    public int getId() {
        return 20;
    }
}

