/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.networking.AbstractChannel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.spinning.SpinningChannelReader;
import com.hazelcast.internal.networking.spinning.SpinningChannelWriter;
import java.nio.channels.SocketChannel;

public class SpinningChannel
extends AbstractChannel {
    private SpinningChannelReader reader;
    private SpinningChannelWriter writer;

    public SpinningChannel(SocketChannel socketChannel, boolean clientMode) {
        super(socketChannel, clientMode);
    }

    public void setReader(SpinningChannelReader reader) {
        this.reader = reader;
    }

    public void setWriter(SpinningChannelWriter writer) {
        this.writer = writer;
    }

    public SpinningChannelReader getReader() {
        return this.reader;
    }

    public SpinningChannelWriter getWriter() {
        return this.writer;
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.isClosed()) {
            return false;
        }
        this.writer.write(frame);
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public long lastReadTimeMillis() {
        return this.reader.lastReadTimeMillis();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.writer.lastWriteTimeMillis();
    }

    public String toString() {
        return "SpinningChannel{" + this.getLocalSocketAddress() + "->" + this.getRemoteSocketAddress() + '}';
    }
}

