/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Traverser;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Traversers {
    private Traversers() {
    }

    @Nonnull
    public static <T> Traverser<T> empty() {
        return () -> null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterator(@Nonnull Iterator<? extends T> iterator) {
        return () -> iterator.hasNext() ? Traversers.ensureNotNull(iterator.next(), "Iterator returned a null item") : null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseSpliterator(@Nonnull Spliterator<T> spliterator) {
        return new SpliteratorTraverser<T>(spliterator);
    }

    @Nonnull
    public static <T> Traverser<T> traverseEnumeration(@Nonnull Enumeration<T> enumeration) {
        return () -> enumeration.hasMoreElements() ? Traversers.ensureNotNull(enumeration.nextElement(), "Enumeration contains a null element") : null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseStream(@Nonnull Stream<T> stream) {
        return Traversers.traverseSpliterator(stream.spliterator()).onFirstNull(stream::close);
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterable(@Nonnull Iterable<? extends T> iterable) {
        return Traversers.traverseIterator(iterable.iterator());
    }

    @Nonnull
    public static <T> Traverser<T> traverseArray(@Nonnull T[] array) {
        return new ArrayTraverser<T>(array);
    }

    @Nonnull
    public static <T> Traverser<T> lazy(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
        return new LazyTraverser<T>(supplierOfTraverser);
    }

    private static <T> T ensureNotNull(@Nullable T t, String failureMsg) {
        assert (t != null) : failureMsg;
        return t;
    }

    private static class SpliteratorTraverser<T>
    implements Traverser<T>,
    Consumer<T> {
        private final Spliterator<T> spliterator;
        private T nextItem;

        SpliteratorTraverser(Spliterator<T> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public T next() {
            try {
                boolean advanced = this.spliterator.tryAdvance(this);
                assert (advanced == (this.nextItem != null)) : "Spliterator emitted a null item";
                T t = this.nextItem;
                return t;
            }
            finally {
                this.nextItem = null;
            }
        }

        @Override
        public void accept(T t) {
            this.nextItem = t;
        }
    }

    private static class ArrayTraverser<T>
    implements Traverser<T> {
        private int i;
        private final T[] array;

        ArrayTraverser(@Nonnull T[] array) {
            this.array = array;
        }

        @Override
        public T next() {
            return (T)(this.i >= 0 && this.i < this.array.length ? Traversers.ensureNotNull(this.array[this.i++], "Array contains a null element") : null);
        }
    }

    private static final class LazyTraverser<T>
    implements Traverser<T> {
        private Supplier<Traverser<T>> supplierOfTraverser;
        private Traverser<T> traverser;

        LazyTraverser(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
            this.supplierOfTraverser = supplierOfTraverser;
        }

        @Override
        public T next() {
            Traverser<T> trav = this.traverser;
            if (trav != null) {
                return trav.next();
            }
            try {
                this.traverser = this.supplierOfTraverser.get();
                T t = this.traverser.next();
                return t;
            }
            finally {
                this.supplierOfTraverser = null;
            }
        }
    }
}

