/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedIntFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import java.io.Closeable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class CloseableProcessorSupplier<E extends Processor & Closeable>
implements ProcessorSupplier {
    static final long serialVersionUID = 1L;
    private final DistributedIntFunction<Collection<E>> supplier;
    private transient ILogger logger;
    private transient Collection<E> processors;

    public CloseableProcessorSupplier(DistributedSupplier<E> simpleSupplier) {
        this(count -> IntStream.range(0, count).mapToObj(i -> (Processor)simpleSupplier.get()).collect(Collectors.toList()));
    }

    public CloseableProcessorSupplier(DistributedIntFunction<Collection<E>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.logger = context.logger();
    }

    @Nonnull
    public Collection<E> get(int count) {
        assert (this.processors == null);
        this.processors = (Collection)this.supplier.apply(count);
        return this.processors;
    }

    @Override
    public void complete(Throwable error) {
        if (this.processors == null) {
            return;
        }
        Throwable firstError = null;
        for (Processor p : this.processors) {
            try {
                ((Closeable)((Object)p)).close();
            }
            catch (Throwable e) {
                if (firstError == null) {
                    firstError = e;
                    continue;
                }
                this.logger.severe(e);
            }
        }
        if (firstError != null) {
            throw ExceptionUtil.sneakyThrow(firstError);
        }
    }
}

