/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.logging.ILogger;
import javax.annotation.Nonnull;

public interface Processor {
    default public boolean isCooperative() {
        return true;
    }

    default public void init(@Nonnull Outbox outbox, @Nonnull Context context) {
    }

    default public void process(int ordinal, @Nonnull Inbox inbox) {
    }

    default public boolean tryProcess() {
        return true;
    }

    default public boolean completeEdge(int ordinal) {
        return true;
    }

    default public boolean complete() {
        return true;
    }

    default public boolean saveToSnapshot() {
        return true;
    }

    default public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        throw new JetException("Processor " + this.getClass().getName() + " does not override the restoreFromSnapshot() method");
    }

    default public boolean finishSnapshotRestore() {
        return true;
    }

    public static interface Context {
        @Nonnull
        public JetInstance jetInstance();

        @Nonnull
        public ILogger logger();

        public int globalProcessorIndex();

        @Nonnull
        public String vertexName();

        default public boolean snapshottingEnabled() {
            return this.processingGuarantee() != ProcessingGuarantee.NONE;
        }

        public ProcessingGuarantee processingGuarantee();
    }
}

