/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.function.DistributedSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface ProcessorMetaSupplier
extends Serializable {
    default public int preferredLocalParallelism() {
        return -1;
    }

    default public void init(@Nonnull Context context) {
    }

    @Nonnull
    public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> var1);

    default public void complete(Throwable error) {
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull ProcessorSupplier procSupplier, int preferredLocalParallelism) {
        return ProcessorMetaSupplier.of(x -> procSupplier, preferredLocalParallelism);
    }

    public static ProcessorMetaSupplier dontParallelize(ProcessorSupplier supplier) {
        return ProcessorMetaSupplier.of(supplier, 1);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull ProcessorSupplier procSupplier) {
        return ProcessorMetaSupplier.of(procSupplier, -1);
    }

    @Nonnull
    public static ProcessorMetaSupplier dontParallelize(@Nonnull DistributedSupplier<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(ProcessorSupplier.of(procSupplier), 1);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull DistributedSupplier<? extends Processor> procSupplier, int preferredLocalParallelism) {
        return ProcessorMetaSupplier.of(ProcessorSupplier.of(procSupplier), preferredLocalParallelism);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull DistributedSupplier<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(procSupplier, -1);
    }

    public static ProcessorMetaSupplier of(final DistributedFunction<Address, ProcessorSupplier> addressToSupplier, final int preferredLocalParallelism) {
        return new ProcessorMetaSupplier(){

            @Override
            public int preferredLocalParallelism() {
                return preferredLocalParallelism;
            }

            @Override
            @Nonnull
            public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return addressToSupplier;
            }
        };
    }

    public static ProcessorMetaSupplier of(DistributedFunction<Address, ProcessorSupplier> addressToSupplier) {
        return ProcessorMetaSupplier.of(addressToSupplier, -1);
    }

    public static interface Context {
        @Nonnull
        public JetInstance jetInstance();

        public int totalParallelism();

        public int localParallelism();

        @Nonnull
        public ILogger logger();
    }
}

