/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.util.Preconditions;
import java.io.Serializable;

public class WindowDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long frameLength;
    private final long frameOffset;
    private final long windowLength;

    WindowDefinition(long frameLength, long frameOffset, long framesPerWindow) {
        Preconditions.checkPositive(frameLength, "frameLength must be positive");
        Preconditions.checkNotNegative(frameOffset, "frameOffset must not be negative");
        Preconditions.checkTrue(frameOffset < frameLength, "frameOffset must be less than frameLength");
        Preconditions.checkPositive(framesPerWindow, "framesPerWindow must be positive");
        this.frameLength = frameLength;
        this.frameOffset = frameOffset;
        this.windowLength = frameLength * framesPerWindow;
    }

    public long frameLength() {
        return this.frameLength;
    }

    public long frameOffset() {
        return this.frameOffset;
    }

    public long windowLength() {
        return this.windowLength;
    }

    public boolean isTumbling() {
        return this.windowLength == this.frameLength;
    }

    public long floorFrameTs(long timestamp) {
        return Util.subtractClamped(timestamp, Math.floorMod((timestamp >= Long.MIN_VALUE + this.frameOffset ? timestamp : timestamp + this.frameLength) - this.frameOffset, this.frameLength));
    }

    public long higherFrameTs(long timestamp) {
        long tsPlusFrame = timestamp + this.frameLength;
        return Util.sumHadOverflow(timestamp, this.frameLength, tsPlusFrame) ? Util.addClamped(this.floorFrameTs(timestamp), this.frameLength) : this.floorFrameTs(tsPlusFrame);
    }

    public WindowDefinition withOffset(long offset) {
        return new WindowDefinition(this.frameLength, offset, this.windowLength / this.frameLength);
    }

    public WindowDefinition toTumblingByFrame() {
        return new WindowDefinition(this.frameLength, this.frameOffset, 1L);
    }

    public static WindowDefinition slidingWindowDef(long windowLength, long slideBy) {
        Preconditions.checkTrue(windowLength % slideBy == 0L, "windowLength must be a multiple of slideBy");
        return new WindowDefinition(slideBy, 0L, windowLength / slideBy);
    }

    public static WindowDefinition tumblingWindowDef(long windowLength) {
        return WindowDefinition.slidingWindowDef(windowLength, windowLength);
    }
}

