/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import com.hazelcast.jet.datamodel.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class BagsByTag {
    private final Map<Tag<?>, Collection> components = new HashMap();

    @Nonnull
    public static BagsByTag bagsByTag(Object ... tagsAndBags) {
        BagsByTag bbt = new BagsByTag();
        int i = 0;
        while (i < tagsAndBags.length) {
            bbt.components.put((Tag)tagsAndBags[i++], new ArrayList((Collection)tagsAndBags[i++]));
        }
        return bbt;
    }

    @Nonnull
    public <E> Collection<E> bag(@Nonnull Tag<E> tag) {
        Collection bag = this.components.get(tag);
        if (bag == null) {
            throw new IllegalArgumentException("No bag associated with tag " + tag);
        }
        return bag;
    }

    @Nonnull
    public <E> Collection<E> ensureBag(@Nonnull Tag<E> tag) {
        return this.components.computeIfAbsent(tag, x -> new ArrayList());
    }

    public void combineWith(@Nonnull BagsByTag that) {
        that.components.forEach((k, v) -> this.ensureBag((Tag)k).addAll((Collection)v));
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BagsByTag && this.components.equals(((BagsByTag)o).components);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public String toString() {
        return "BagsByTag " + this.components.toString();
    }

    @Nonnull
    Set<Map.Entry<Tag<?>, Collection>> entrySet() {
        return this.components.entrySet();
    }

    void put(@Nonnull Tag<?> tag, @Nonnull ArrayList list) {
        this.components.put(tag, list);
    }
}

