/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import javax.annotation.Nonnull;

public final class TimestampedEntry<K, V>
implements Map.Entry<K, V> {
    private final long timestamp;
    private final K key;
    private final V value;

    public TimestampedEntry(long timestamp, @Nonnull K key, @Nonnull V value) {
        this.timestamp = timestamp;
        this.key = key;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nonnull
    public K getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public int hashCode() {
        int hc = 17;
        hc = 73 * hc + Long.hashCode(this.timestamp);
        hc = 73 * hc + this.key.hashCode();
        hc = 73 * hc + this.value.hashCode();
        return hc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TimestampedEntry)) return false;
        TimestampedEntry that = (TimestampedEntry)obj;
        if (this.timestamp != that.timestamp) return false;
        if (!this.key.equals(that.key)) return false;
        if (!this.value.equals(that.value)) return false;
        return true;
    }

    public String toString() {
        return "TimestampedEntry{ts=" + this.timestamp + ", formattedTs=" + Instant.ofEpochMilli(this.timestamp).atZone(ZoneId.systemDefault()).toLocalTime() + ", key=" + this.key + ", value=" + this.value + '}';
    }
}

