/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

public final class TwoBags<E0, E1> {
    private final Collection<E0> bag0;
    private final Collection<E1> bag1;

    private TwoBags(@Nonnull Collection<E0> bag0, @Nonnull Collection<E1> bag1) {
        this.bag0 = new ArrayList<E0>(bag0);
        this.bag1 = new ArrayList<E1>(bag1);
    }

    @Nonnull
    public static <E0, E1> TwoBags<E0, E1> twoBags() {
        return new TwoBags(Collections.emptyList(), Collections.emptyList());
    }

    @Nonnull
    public static <E0, E1> TwoBags<E0, E1> twoBags(@Nonnull Collection<E0> bag0, @Nonnull Collection<E1> bag1) {
        return new TwoBags<E0, E1>(bag0, bag1);
    }

    @Nonnull
    public Collection<E0> bag0() {
        return this.bag0;
    }

    @Nonnull
    public Collection<E1> bag1() {
        return this.bag1;
    }

    public void combineWith(@Nonnull TwoBags<E0, E1> that) {
        this.bag0.addAll(that.bag0());
        this.bag1.addAll(that.bag1());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TwoBags)) return false;
        TwoBags that = (TwoBags)o;
        if (!this.bag0.equals(that.bag0)) return false;
        if (!this.bag1.equals(that.bag1)) return false;
        return true;
    }

    public int hashCode() {
        int hc = this.bag0.hashCode();
        hc = 73 * hc + this.bag1.hashCode();
        return hc;
    }
}

