/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.AbstractJobImpl;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public abstract class AbstractSubmittedJobImpl
extends AbstractJobImpl {
    protected final DAG dag;
    protected final JobConfig config;
    private final JobRepository jobRepository;
    private Long jobId;

    AbstractSubmittedJobImpl(JetInstance jetInstance, ILogger logger, DAG dag, JobConfig config) {
        super(logger);
        this.jobRepository = new JobRepository(jetInstance, null);
        this.dag = dag;
        this.config = config;
    }

    @Override
    @Nonnull
    public final CompletableFuture<Void> getFuture() {
        if (this.jobId == null) {
            throw new IllegalStateException("Job is not initialized yet!");
        }
        return super.getFuture();
    }

    @Override
    public final long getJobId() {
        if (this.jobId == null) {
            throw new IllegalStateException("ID not yet assigned");
        }
        return this.jobId;
    }

    @Override
    final void init() {
        if (this.jobId != null) {
            throw new IllegalStateException("Job already started");
        }
        Address masterAddress = this.getMasterAddress();
        if (masterAddress == null) {
            throw new IllegalStateException("Master address is null");
        }
        this.jobId = this.jobRepository.uploadJobResources(this.config);
        super.init();
    }
}

