/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.AbstractSubmittedJobImpl;
import com.hazelcast.jet.impl.AbstractTrackedJobImpl;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.operation.GetJobStatusOperation;
import com.hazelcast.jet.impl.operation.JoinSubmittedJobOperation;
import com.hazelcast.jet.impl.operation.SubmitJobOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class JetInstanceImpl
extends AbstractJetInstance {
    private final NodeEngine nodeEngine;
    private final JetConfig config;

    public JetInstanceImpl(HazelcastInstanceImpl hazelcastInstance, JetConfig config) {
        super(hazelcastInstance);
        this.nodeEngine = hazelcastInstance.node.getNodeEngine();
        this.config = config;
    }

    @Override
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    public Job newJob(DAG dag) {
        ILogger logger = this.nodeEngine.getLogger(SubmittedJobImpl.class);
        SubmittedJobImpl job = new SubmittedJobImpl(this, logger, dag, new JobConfig());
        job.init();
        return job;
    }

    @Override
    public Job newJob(DAG dag, JobConfig config) {
        ILogger logger = this.nodeEngine.getLogger(SubmittedJobImpl.class);
        SubmittedJobImpl job = new SubmittedJobImpl(this, logger, dag, config);
        job.init();
        return job;
    }

    @Override
    public Collection<Job> getJobs() {
        Set jobIds;
        Address masterAddress = this.nodeEngine.getMasterAddress();
        OperationService operationService = this.nodeEngine.getOperationService();
        InternalCompletableFuture future = operationService.createInvocationBuilder("hz:impl:jetService", (Operation)new GetJobIdsOperation(), masterAddress).invoke();
        try {
            jobIds = (Set)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
        catch (ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
        List<Job> jobs = jobIds.stream().map(jobId -> new TrackedJobImpl(this.nodeEngine.getLogger(TrackedJobImpl.class), (long)jobId)).collect(Collectors.toList());
        jobs.forEach(job -> ((TrackedJobImpl)job).init());
        return jobs;
    }

    private JobStatus sendJobStatusRequest(long jobId, boolean rertryOnNotFound) {
        try {
            GetJobStatusOperation op = new GetJobStatusOperation(jobId, rertryOnNotFound);
            OperationService operationService = this.nodeEngine.getOperationService();
            InternalCompletableFuture f = operationService.createInvocationBuilder("hz:impl:jetService", (Operation)op, this.nodeEngine.getMasterAddress()).invoke();
            return (JobStatus)((Object)f.get());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private class TrackedJobImpl
    extends AbstractTrackedJobImpl {
        TrackedJobImpl(ILogger logger, long jobId) {
            super(logger, jobId);
        }

        @Override
        protected Address getMasterAddress() {
            return JetInstanceImpl.this.nodeEngine.getMasterAddress();
        }

        @Override
        protected ICompletableFuture<Void> sendJoinRequest(Address masterAddress) {
            JoinSubmittedJobOperation op = new JoinSubmittedJobOperation(this.getJobId());
            return JetInstanceImpl.this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)op, masterAddress).invoke();
        }

        @Override
        protected JobStatus sendJobStatusRequest() {
            return JetInstanceImpl.this.sendJobStatusRequest(this.getJobId(), false);
        }
    }

    private class SubmittedJobImpl
    extends AbstractSubmittedJobImpl {
        SubmittedJobImpl(JetInstance jetInstance, ILogger logger, DAG dag, JobConfig config) {
            super(jetInstance, logger, dag, config);
        }

        @Override
        protected Address getMasterAddress() {
            return JetInstanceImpl.this.nodeEngine.getMasterAddress();
        }

        @Override
        protected ICompletableFuture<Void> sendJoinRequest(Address masterAddress) {
            Object serializedDag = JetInstanceImpl.this.nodeEngine.getSerializationService().toData(this.dag);
            SubmitJobOperation op = new SubmitJobOperation(this.getJobId(), (Data)serializedDag, this.config);
            return JetInstanceImpl.this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)op, masterAddress).invoke();
        }

        @Override
        protected JobStatus sendJobStatusRequest() {
            return JetInstanceImpl.this.sendJobStatusRequest(this.getJobId(), true);
        }
    }
}

