/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.SnapshotRepository;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nullable;

public class JobRepository {
    public static final String RESOURCES_MAP_NAME_PREFIX = "__jet.resources.";
    public static final String RANDOM_IDS_MAP_NAME = "__jet.ids";
    public static final String JOB_RECORDS_MAP_NAME = "__jet.records";
    public static final String JOB_RESULTS_MAP_NAME = "__jet.results";
    private static final String RESOURCE_MARKER = "__jet.resourceMarker";
    private static final long JOB_EXPIRATION_DURATION_IN_MILLIS = TimeUnit.HOURS.toMillis(2L);
    private final HazelcastInstance instance;
    private final SnapshotRepository snapshotRepository;
    private final IMap<Long, Long> randomIds;
    private final IMap<Long, JobRecord> jobs;
    private long jobExpirationDurationInMillis = JOB_EXPIRATION_DURATION_IN_MILLIS;

    JobRepository(JetInstance jetInstance, @Nullable SnapshotRepository snapshotRepository) {
        this.instance = jetInstance.getHazelcastInstance();
        this.snapshotRepository = snapshotRepository;
        this.randomIds = this.instance.getMap(RANDOM_IDS_MAP_NAME);
        this.jobs = this.instance.getMap(JOB_RECORDS_MAP_NAME);
    }

    void setJobExpirationDurationInMillis(long jobExpirationDurationInMillis) {
        this.jobExpirationDurationInMillis = jobExpirationDurationInMillis;
    }

    public long uploadJobResources(JobConfig jobConfig) {
        long jobId = this.newJobId();
        IMap<String, Object> jobResourcesMap = this.getJobResources(jobId);
        for (ResourceConfig rc : jobConfig.getResourceConfigs()) {
            HashMap<String, byte[]> tmpMap = new HashMap<String, byte[]>();
            if (rc.isArchive()) {
                try {
                    this.loadJar(tmpMap, rc.getUrl());
                }
                catch (IOException e) {
                    this.cleanupJobResourcesAndSnapshots(jobId, jobResourcesMap);
                    this.randomIds.remove(jobId);
                    throw new JetException("Job resource upload failed", e);
                }
            }
            try {
                InputStream in = rc.getUrl().openStream();
                this.readStreamAndPutCompressedToMap(rc.getId(), tmpMap, in);
            }
            catch (IOException e) {
                this.cleanupJobResourcesAndSnapshots(jobId, jobResourcesMap);
                this.randomIds.remove(jobId);
                throw new JetException("Job resource upload failed", e);
            }
            jobResourcesMap.putAll(tmpMap);
        }
        jobResourcesMap.put(RESOURCE_MARKER, jobId);
        return jobId;
    }

    private long newJobId() {
        long jobId;
        while (this.randomIds.putIfAbsent(jobId = Util.secureRandomNextLong(), jobId) != null) {
        }
        return jobId;
    }

    private void loadJar(Map<String, byte[]> map, URL url) throws IOException {
        try (JarInputStream jis = new JarInputStream(new BufferedInputStream(url.openStream()));){
            JarEntry jarEntry;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory()) continue;
                this.readStreamAndPutCompressedToMap(jarEntry.getName(), map, jis);
            }
        }
    }

    private void readStreamAndPutCompressedToMap(String resourceName, Map<String, byte[]> map, InputStream in) throws IOException {
        if (map.containsKey(resourceName)) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DeflaterOutputStream compressor = new DeflaterOutputStream(baos);){
            IOUtil.drainTo(in, compressor);
        }
        map.put(resourceName, baos.toByteArray());
    }

    private void cleanupJobResourcesAndSnapshots(long jobId, IMap<String, Object> jobResourcesMap) {
        if (this.snapshotRepository != null) {
            this.snapshotRepository.deleteAllSnapshots(jobId);
        }
        jobResourcesMap.destroy();
    }

    void putNewJobRecord(JobRecord jobRecord) {
        long jobId = jobRecord.getJobId();
        JobRecord prev = this.jobs.putIfAbsent(jobId, jobRecord);
        if (prev != null && !prev.getDag().equals(jobRecord.getDag())) {
            throw new IllegalStateException("Cannot put job record for job " + Util.idToString(jobId) + " because it already exists with a different dag");
        }
    }

    boolean updateJobQuorumSizeIfLargerThanCurrent(long jobId, int newQuorumSize) {
        return (Boolean)this.jobs.executeOnKey(jobId, new UpdateJobRecordQuorumEntryProcessor(newQuorumSize));
    }

    long newExecutionId(long jobId) {
        long executionId;
        while (this.randomIds.putIfAbsent(executionId = Util.secureRandomNextLong(), jobId) != null) {
        }
        return executionId;
    }

    void deleteJob(long jobId) {
        this.jobs.remove(jobId);
        this.randomIds.removeAll(new FilterExecutionIdByJobIdPredicate(jobId));
        this.cleanupJobResourcesAndSnapshots(jobId, this.getJobResources(jobId));
    }

    void cleanup(Set<Long> completedJobIds, Set<Long> runningJobIds) {
        completedJobIds.forEach(this::deleteJob);
        HashSet<Long> validJobIds = new HashSet<Long>();
        validJobIds.addAll(completedJobIds);
        validJobIds.addAll(runningJobIds);
        validJobIds.addAll(this.jobs.keySet());
        this.randomIds.keySet(new FilterJobIdPredicate()).stream().filter(jobId -> !validJobIds.contains(jobId)).forEach(jobId -> {
            IMap<String, Object> resources = this.getJobResources((long)jobId);
            if (resources.isEmpty()) {
                return;
            }
            EntryView marker = resources.getEntryView(RESOURCE_MARKER);
            if (marker == null) {
                resources.putIfAbsent(RESOURCE_MARKER, RESOURCE_MARKER);
            } else if (this.isJobExpired(marker.getCreationTime())) {
                this.cleanupJobResourcesAndSnapshots((long)jobId, resources);
            }
        });
    }

    private boolean isJobExpired(long creationTime) {
        return System.currentTimeMillis() - creationTime >= this.jobExpirationDurationInMillis;
    }

    Set<Long> getJobIds() {
        return this.jobs.keySet();
    }

    Collection<JobRecord> getJobRecords() {
        return this.jobs.values();
    }

    public JobRecord getJob(long jobId) {
        return this.jobs.get(jobId);
    }

    <T> IMap<String, T> getJobResources(long jobId) {
        return this.instance.getMap(RESOURCES_MAP_NAME_PREFIX + Util.idToString(jobId));
    }

    public static class UpdateJobRecordQuorumEntryBackupProcessor
    implements EntryBackupProcessor<Long, JobRecord>,
    IdentifiedDataSerializable {
        private int newQuorumSize;

        public UpdateJobRecordQuorumEntryBackupProcessor() {
        }

        UpdateJobRecordQuorumEntryBackupProcessor(int newQuorumSize) {
            this.newQuorumSize = newQuorumSize;
        }

        @Override
        public void processBackup(Map.Entry<Long, JobRecord> entry) {
            JobRecord jobRecord = entry.getValue();
            if (jobRecord == null) {
                return;
            }
            JobRecord newJobRecord = new JobRecord(jobRecord.getJobId(), jobRecord.getCreationTime(), jobRecord.getDag(), jobRecord.getConfig(), this.newQuorumSize);
            entry.setValue(newJobRecord);
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getId() {
            return 19;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.newQuorumSize);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.newQuorumSize = in.readInt();
        }
    }

    public static class UpdateJobRecordQuorumEntryProcessor
    implements EntryProcessor<Long, JobRecord>,
    IdentifiedDataSerializable {
        private int newQuorumSize;
        private boolean updated;

        public UpdateJobRecordQuorumEntryProcessor() {
        }

        UpdateJobRecordQuorumEntryProcessor(int newQuorumSize) {
            this.newQuorumSize = newQuorumSize;
        }

        @Override
        public Object process(Map.Entry<Long, JobRecord> entry) {
            JobRecord jobRecord = entry.getValue();
            if (jobRecord == null) {
                return false;
            }
            boolean bl = this.updated = this.newQuorumSize > jobRecord.getQuorumSize();
            if (this.updated) {
                JobRecord newJobRecord = new JobRecord(jobRecord.getJobId(), jobRecord.getCreationTime(), jobRecord.getDag(), jobRecord.getConfig(), this.newQuorumSize);
                entry.setValue(newJobRecord);
            }
            return this.updated;
        }

        @Override
        public EntryBackupProcessor<Long, JobRecord> getBackupProcessor() {
            return this.updated ? new UpdateJobRecordQuorumEntryBackupProcessor(this.newQuorumSize) : null;
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getId() {
            return 18;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.newQuorumSize);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.newQuorumSize = in.readInt();
        }
    }

    public static class FilterJobIdPredicate
    implements Predicate<Long, Long>,
    IdentifiedDataSerializable {
        @Override
        public boolean apply(Map.Entry<Long, Long> mapEntry) {
            return mapEntry.getKey().equals(mapEntry.getValue());
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getId() {
            return 14;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
        }
    }

    public static class FilterExecutionIdByJobIdPredicate
    implements Predicate<Long, Long>,
    IdentifiedDataSerializable {
        private long jobId;

        public FilterExecutionIdByJobIdPredicate() {
        }

        FilterExecutionIdByJobIdPredicate(long jobId) {
            this.jobId = jobId;
        }

        @Override
        public boolean apply(Map.Entry<Long, Long> mapEntry) {
            return mapEntry.getKey() != this.jobId && mapEntry.getValue() == this.jobId;
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getId() {
            return 13;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.jobId);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.jobId = in.readLong();
        }
    }
}

