/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;

public class JobResult
implements IdentifiedDataSerializable {
    private String coordinatorUUID;
    private long jobId;
    private long creationTime;
    private long completionTime;
    private Throwable failure;

    public JobResult() {
    }

    public JobResult(long jobId, String coordinatorUUID, long creationTime, Long completionTime, Throwable failure) {
        this.jobId = jobId;
        this.coordinatorUUID = coordinatorUUID;
        this.creationTime = creationTime;
        this.completionTime = completionTime;
        this.failure = failure;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getCoordinatorUUID() {
        return this.coordinatorUUID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    public boolean isSuccessful() {
        return this.failure == null;
    }

    public boolean isSuccessfulOrCancelled() {
        return this.failure == null || this.failure instanceof CancellationException;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public JobStatus getJobStatus() {
        return this.isSuccessfulOrCancelled() ? JobStatus.COMPLETED : JobStatus.FAILED;
    }

    public CompletableFuture<Boolean> asCompletableFuture() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (this.failure == null) {
            future.complete(true);
        } else {
            future.completeExceptionally(this.failure);
        }
        return future;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobResult jobResult = (JobResult)o;
        if (this.jobId != jobResult.jobId) {
            return false;
        }
        if (this.creationTime != jobResult.creationTime) {
            return false;
        }
        if (this.completionTime != jobResult.completionTime) {
            return false;
        }
        if (!this.coordinatorUUID.equals(jobResult.coordinatorUUID)) {
            return false;
        }
        return this.failure.equals(jobResult.failure);
    }

    public int hashCode() {
        int result = this.coordinatorUUID.hashCode();
        result = 31 * result + (int)(this.jobId ^ this.jobId >>> 32);
        result = 31 * result + (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (int)(this.completionTime ^ this.completionTime >>> 32);
        result = 31 * result + this.failure.hashCode();
        return result;
    }

    public String toString() {
        return "JobResult{coordinatorUUID='" + this.coordinatorUUID + '\'' + ", jobId=" + Util.idToString(this.jobId) + ", creationTime=" + Instant.ofEpochMilli(this.creationTime).atZone(ZoneId.systemDefault()) + ", completionTime=" + Instant.ofEpochMilli(this.completionTime).atZone(ZoneId.systemDefault()) + ", failure=" + this.failure + '}';
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeUTF(this.coordinatorUUID);
        out.writeLong(this.creationTime);
        out.writeLong(this.completionTime);
        out.writeObject(this.failure);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.coordinatorUUID = in.readUTF();
        this.creationTime = in.readLong();
        this.completionTime = in.readLong();
        this.failure = (Throwable)in.readObject();
    }
}

