/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SnapshotContext {
    public static final int NO_SNAPSHOT = -1;
    private final ILogger logger;
    private final long jobId;
    private final long executionId;
    private final ProcessingGuarantee guarantee;
    private final AtomicLong lastSnapshotId;
    private int numTasklets = Integer.MIN_VALUE;
    private int numHigherPriorityTasklets = Integer.MIN_VALUE;
    private final AtomicInteger numRemainingTasklets = new AtomicInteger();
    private final AtomicReference<Throwable> snapshotError = new AtomicReference();
    private boolean snapshotPostponed;
    private volatile CompletableFuture<Void> future;

    SnapshotContext(ILogger logger, long jobId, long executionId, long lastSnapshotId, ProcessingGuarantee guarantee) {
        this.jobId = jobId;
        this.executionId = executionId;
        this.lastSnapshotId = new AtomicLong(lastSnapshotId);
        this.guarantee = guarantee;
        this.logger = logger;
    }

    long lastSnapshotId() {
        return this.lastSnapshotId.get();
    }

    ProcessingGuarantee processingGuarantee() {
        return this.guarantee;
    }

    synchronized void initTaskletCount(int taskletCount, int highPriorityTaskletCount) {
        assert (this.numTasklets == Integer.MIN_VALUE) : "Tasklet count already set once.";
        assert (taskletCount >= highPriorityTaskletCount) : "taskletCount=" + taskletCount + ", highPriorityTaskletCount=" + highPriorityTaskletCount;
        assert (taskletCount > 0) : "taskletCount=" + taskletCount;
        assert (highPriorityTaskletCount >= 0) : "highPriorityTaskletCount=" + highPriorityTaskletCount;
        this.numTasklets = taskletCount;
        this.numHigherPriorityTasklets = highPriorityTaskletCount;
    }

    synchronized CompletableFuture<Void> startNewSnapshot(long snapshotId) {
        assert (snapshotId == this.lastSnapshotId.get() + 1L) : "new snapshotId not incremented by 1. Previous=" + this.lastSnapshotId + ", new=" + snapshotId;
        assert (this.numTasklets >= 0) : "numTasklets=" + this.numTasklets;
        int newNumRemainingTasklets = this.numRemainingTasklets.addAndGet(this.numTasklets);
        assert (newNumRemainingTasklets - this.numTasklets <= 0) : "previous snapshot was not finished, numRemainingTasklets=" + (newNumRemainingTasklets - this.numTasklets);
        if (this.numHigherPriorityTasklets == 0) {
            this.lastSnapshotId.set(snapshotId);
        } else {
            this.logger.warning("Snapshot " + snapshotId + " for " + Util.jobAndExecutionId(this.jobId, this.executionId) + " is postponed" + " until all higher priority vertices are completed (number of vertices = " + this.numHigherPriorityTasklets + ')');
            this.snapshotPostponed = true;
        }
        if (this.numTasklets == 0) {
            return Util.completedVoidFuture();
        }
        this.future = new CompletableFuture<Void>();
        CompletableFuture<Void> res = this.future;
        if (newNumRemainingTasklets == 0) {
            this.handleSnapshotDone();
        }
        return res;
    }

    synchronized void taskletDone(long lastSnapshotId, boolean isHigherPrioritySource) {
        assert (this.numTasklets > 0) : "numTasklets=" + this.numTasklets;
        assert (lastSnapshotId <= this.lastSnapshotId.get() + 1L) : "this.lastSnapshotId=" + this.lastSnapshotId.get() + "tasklet.lastSnapshotId=" + lastSnapshotId;
        --this.numTasklets;
        if (isHigherPrioritySource) {
            assert (this.numHigherPriorityTasklets > 0) : "numHigherPriorityTasklets=" + this.numHigherPriorityTasklets;
            --this.numHigherPriorityTasklets;
            if (this.numHigherPriorityTasklets == 0 && this.snapshotPostponed) {
                this.lastSnapshotId.incrementAndGet();
                this.logger.info("Postponed snapshot " + this.lastSnapshotId + " for " + Util.jobAndExecutionId(this.jobId, this.executionId) + " started");
            }
        }
        if (this.lastSnapshotId.get() > lastSnapshotId) {
            this.snapshotDoneForTasklet();
        } else if (this.lastSnapshotId.get() < lastSnapshotId) {
            this.numRemainingTasklets.incrementAndGet();
        }
    }

    void snapshotDoneForTasklet() {
        if (this.numRemainingTasklets.decrementAndGet() == 0) {
            this.handleSnapshotDone();
        }
    }

    private void handleSnapshotDone() {
        Throwable t = this.snapshotError.get();
        if (t == null) {
            Util.completeVoidFuture(this.future);
        } else {
            this.future.completeExceptionally(t);
        }
        this.future = null;
        this.snapshotError.set(null);
    }

    void reportError(Throwable ex) {
        this.snapshotError.compareAndSet(null, ex);
    }

    public AtomicInteger getNumRemainingTasklets() {
        return this.numRemainingTasklets;
    }
}

