/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public abstract class AsyncExecutionOperation
extends Operation
implements IdentifiedDataSerializable {
    protected long jobId;

    protected AsyncExecutionOperation() {
    }

    protected AsyncExecutionOperation(long jobId) {
        this.jobId = jobId;
    }

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeRun() throws Exception {
        JetService service = (JetService)this.getService();
        service.getLiveOperationRegistry().register(this);
    }

    @Override
    public final void run() throws Exception {
        try {
            this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
        }
    }

    public void cancel() {
    }

    protected abstract void doRun() throws Exception;

    public long getJobId() {
        return this.jobId;
    }

    public final void doSendResponse(Object value) {
        try {
            this.sendResponse(value);
        }
        finally {
            JetService service = (JetService)this.getService();
            service.getLiveOperationRegistry().deregister(this);
        }
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isTopologicalFailure(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.jobId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobId = in.readLong();
    }
}

