/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.core.WatermarkEmissionPolicy;
import com.hazelcast.jet.core.WatermarkPolicy;
import com.hazelcast.jet.function.DistributedToLongFunction;
import com.hazelcast.jet.impl.util.LoggingUtil;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;

public class InsertWatermarksP<T>
extends AbstractProcessor {
    private final ToLongFunction<T> getTimestampF;
    private final WatermarkPolicy wmPolicy;
    private final WatermarkEmissionPolicy wmEmitPolicy;
    private final ResettableSingletonTraverser<Object> singletonTraverser;
    private final AbstractProcessor.FlatMapper<Object, Object> flatMapper;
    private long currWm = Long.MIN_VALUE;
    private long lastEmittedWm = Long.MIN_VALUE;
    private long minRestoredWm = Long.MAX_VALUE;

    public InsertWatermarksP(@Nonnull DistributedToLongFunction<T> getTimestampF, @Nonnull WatermarkPolicy wmPolicy, @Nonnull WatermarkEmissionPolicy wmEmitPolicy) {
        this.getTimestampF = getTimestampF;
        this.wmPolicy = wmPolicy;
        this.wmEmitPolicy = wmEmitPolicy;
        this.flatMapper = this.flatMapper(this::traverser);
        this.singletonTraverser = new ResettableSingletonTraverser();
    }

    @Override
    public boolean tryProcess() {
        this.currWm = this.wmPolicy.getCurrentWatermark();
        if (!this.wmEmitPolicy.shouldEmit(this.currWm, this.lastEmittedWm)) {
            return true;
        }
        boolean didEmit = this.tryEmit(new Watermark(this.currWm));
        if (didEmit) {
            this.lastEmittedWm = this.currWm;
        }
        return didEmit;
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) throws Exception {
        return this.flatMapper.tryProcess(item);
    }

    @Override
    public boolean saveToSnapshot() {
        return this.tryEmitToSnapshot(BroadcastKey.broadcastKey(Keys.LAST_EMITTED_WM), this.lastEmittedWm);
    }

    @Override
    public void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        assert (((BroadcastKey)key).key().equals((Object)Keys.LAST_EMITTED_WM)) : "Unexpected key: " + key;
        this.minRestoredWm = Math.min(this.minRestoredWm, (Long)value);
    }

    @Override
    public boolean finishSnapshotRestore() {
        this.lastEmittedWm = this.minRestoredWm;
        LoggingUtil.logFine(this.getLogger(), "restored lastEmittedWm=%s", this.lastEmittedWm);
        return true;
    }

    private Traverser<Object> traverser(Object item) {
        long timestamp = this.getTimestampF.applyAsLong(item);
        this.currWm = this.wmPolicy.reportEvent(timestamp);
        if (timestamp >= this.currWm) {
            this.singletonTraverser.accept(item);
        } else if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Dropped late event: " + item);
        }
        if (this.wmEmitPolicy.shouldEmit(this.currWm, this.lastEmittedWm)) {
            this.lastEmittedWm = this.currWm;
            return this.singletonTraverser.prepend(new Watermark(this.currWm));
        }
        return this.singletonTraverser;
    }

    private static enum Keys {
        LAST_EMITTED_WM;

    }
}

