/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Preconditions;
import java.util.BitSet;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class PeekWrappedP<T>
implements Processor {
    private final Processor wrappedProcessor;
    private final DistributedFunction<T, String> toStringFn;
    private final Predicate<T> shouldLogFn;
    private final LoggingInbox loggingInbox;
    private ILogger logger;
    private final boolean peekInput;
    private final boolean peekOutput;
    private final boolean peekSnapshot;

    public PeekWrappedP(@Nonnull Processor wrappedProcessor, @Nonnull DistributedFunction<T, String> toStringFn, @Nonnull Predicate<T> shouldLogFn, boolean peekInput, boolean peekOutput, boolean peekSnapshot) {
        Preconditions.checkNotNull(wrappedProcessor, "wrappedProcessor");
        Preconditions.checkNotNull(toStringFn, "toStringFn");
        Preconditions.checkNotNull(shouldLogFn, "shouldLogFn");
        this.wrappedProcessor = wrappedProcessor;
        this.toStringFn = toStringFn;
        this.shouldLogFn = shouldLogFn;
        this.peekInput = peekInput;
        this.peekOutput = peekOutput;
        this.peekSnapshot = peekSnapshot;
        this.loggingInbox = peekInput ? new LoggingInbox() : null;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.logger = context.logger();
        outbox = new LoggingOutbox(outbox, this.peekOutput, this.peekSnapshot);
        this.wrappedProcessor.init(outbox, context);
    }

    @Override
    public boolean isCooperative() {
        return this.wrappedProcessor.isCooperative();
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (this.peekInput) {
            this.loggingInbox.wrappedInbox = inbox;
            this.loggingInbox.ordinal = ordinal;
            this.wrappedProcessor.process(ordinal, this.loggingInbox);
        } else {
            this.wrappedProcessor.process(ordinal, inbox);
        }
    }

    @Override
    public boolean tryProcess() {
        return this.wrappedProcessor.tryProcess();
    }

    @Override
    public boolean complete() {
        return this.wrappedProcessor.complete();
    }

    private void log(String prefix, T object) {
        if (object != null && this.shouldLogFn.test(object)) {
            this.logger.info(prefix + ": " + (String)this.toStringFn.apply(object));
        }
    }

    @Override
    public boolean completeEdge(int ordinal) {
        return this.wrappedProcessor.completeEdge(ordinal);
    }

    @Override
    public boolean saveToSnapshot() {
        return this.wrappedProcessor.saveToSnapshot();
    }

    @Override
    public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        this.wrappedProcessor.restoreFromSnapshot(inbox);
    }

    @Override
    public boolean finishSnapshotRestore() {
        return this.wrappedProcessor.finishSnapshotRestore();
    }

    private final class LoggingOutbox
    implements Outbox {
        private final Outbox wrappedOutbox;
        private final int[] all;
        private final boolean logOutput;
        private final boolean logSnapshot;
        private final BitSet broadcastTracker;

        private LoggingOutbox(Outbox wrappedOutbox, boolean logOutput, boolean logSnapshot) {
            this.wrappedOutbox = wrappedOutbox;
            this.broadcastTracker = new BitSet(wrappedOutbox.bucketCount());
            this.all = IntStream.range(0, wrappedOutbox.bucketCount()).toArray();
            this.logOutput = logOutput;
            this.logSnapshot = logSnapshot;
        }

        @Override
        public int bucketCount() {
            return this.wrappedOutbox.bucketCount();
        }

        @Override
        public boolean offer(int ordinal, @Nonnull Object item) {
            if (ordinal == -1) {
                return this.offer(this.all, item);
            }
            if (!this.wrappedOutbox.offer(ordinal, item)) {
                return false;
            }
            if (this.logOutput) {
                PeekWrappedP.this.log("Output to " + ordinal, item);
            }
            return true;
        }

        @Override
        public boolean offer(int[] ordinals, @Nonnull Object item) {
            boolean done = true;
            for (int i = 0; i < ordinals.length; ++i) {
                if (this.broadcastTracker.get(i)) continue;
                if (this.offer(i, item)) {
                    this.broadcastTracker.set(i);
                    continue;
                }
                done = false;
            }
            if (done) {
                this.broadcastTracker.clear();
            }
            return done;
        }

        @Override
        public boolean offerToSnapshot(@Nonnull Object key, @Nonnull Object value) {
            if (!this.wrappedOutbox.offerToSnapshot(key, value)) {
                return false;
            }
            if (this.logSnapshot) {
                PeekWrappedP.this.log("Output to snapshot", Util.entry(key, value));
            }
            return true;
        }
    }

    private class LoggingInbox
    implements Inbox {
        private Inbox wrappedInbox;
        private boolean peekedItemLogged;
        private int ordinal;

        private LoggingInbox() {
        }

        @Override
        public boolean isEmpty() {
            return this.wrappedInbox.isEmpty();
        }

        @Override
        public Object peek() {
            Object res = this.wrappedInbox.peek();
            if (!this.peekedItemLogged && res != null) {
                this.log(res);
                this.peekedItemLogged = true;
            }
            return res;
        }

        @Override
        public Object poll() {
            Object res = this.wrappedInbox.poll();
            if (!this.peekedItemLogged && res != null) {
                this.log(res);
            }
            this.peekedItemLogged = false;
            return res;
        }

        private void log(T res) {
            PeekWrappedP.this.log("Input from " + this.ordinal, res);
        }

        @Override
        public Object remove() {
            this.peekedItemLogged = false;
            return this.wrappedInbox.remove();
        }
    }
}

