/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.distributed;

import com.hazelcast.jet.function.DistributedComparator;

public final class DistributedComparators {
    public static final DistributedComparator<Comparable<Object>> NATURAL_ORDER_COMPARATOR = new NaturalOrderComparator();
    public static final DistributedComparator<Comparable<Object>> REVERSE_ORDER_COMPARATOR = new ReverseOrderComparator();

    private DistributedComparators() {
    }

    public static final class NullComparator<T>
    implements DistributedComparator<T> {
        private static final long serialVersionUID = -7569533591570686392L;
        private final boolean nullFirst;

        public NullComparator(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        @Override
        public int compare(T a, T b) {
            if (a == null) {
                return b == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b == null) {
                return this.nullFirst ? 1 : -1;
            }
            return 0;
        }
    }

    private static class ReverseOrderComparator
    implements DistributedComparator<Comparable<Object>> {
        private ReverseOrderComparator() {
        }

        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c2.compareTo(c1);
        }

        @Override
        public DistributedComparator<Comparable<Object>> reversed() {
            return NATURAL_ORDER_COMPARATOR;
        }
    }

    private static class NaturalOrderComparator
    implements DistributedComparator<Comparable<Object>> {
        private NaturalOrderComparator() {
        }

        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }

        @Override
        public DistributedComparator<Comparable<Object>> reversed() {
            return REVERSE_ORDER_COMPARATOR;
        }
    }
}

