/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.core.IList;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.function.DistributedBiConsumer;
import com.hazelcast.jet.function.DistributedComparator;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.stream.DistributedCollectors;
import com.hazelcast.jet.stream.DistributedDoubleStream;
import com.hazelcast.jet.stream.DistributedIntStream;
import com.hazelcast.jet.stream.DistributedLongStream;
import com.hazelcast.jet.stream.DistributedStream;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.distributed.DistributedDoubleSummaryStatistics;
import com.hazelcast.jet.stream.impl.pipeline.IntPipeline;
import com.hazelcast.jet.stream.impl.pipeline.LongPipe;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

class DoublePipeline
implements DistributedDoubleStream {
    private final StreamContext context;
    private final Pipe<Double> inner;

    DoublePipeline(StreamContext context, Pipe<Double> inner) {
        this.context = context;
        this.inner = inner;
    }

    @Override
    public DistributedDoubleStream filter(DoublePredicate predicate) {
        Util.checkSerializable(predicate, "predicate");
        DistributedStream<Double> filter = this.inner.filter(predicate::test);
        return this.wrap(filter);
    }

    @Override
    public DistributedDoubleStream map(DoubleUnaryOperator mapper) {
        Util.checkSerializable(mapper, "mapper");
        DistributedStream<Double> map = this.inner.map(mapper::applyAsDouble);
        return this.wrap(map);
    }

    @Override
    public <U> DistributedStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        Util.checkSerializable(mapper, "mapper");
        return this.inner.map(mapper::apply);
    }

    @Override
    public DistributedIntStream mapToInt(DoubleToIntFunction mapper) {
        Util.checkSerializable(mapper, "mapper");
        DistributedStream stream = this.inner.map(mapper::applyAsInt);
        return new IntPipeline(this.context, (Pipe)stream);
    }

    @Override
    public DistributedLongStream mapToLong(DoubleToLongFunction mapper) {
        Util.checkSerializable(mapper, "mapper");
        DistributedStream stream = this.inner.map(mapper::applyAsLong);
        return new LongPipe(this.context, (Pipe)stream);
    }

    @Override
    public DistributedDoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        Util.checkSerializable(mapper, "mapper");
        return this.wrap(this.inner.flatMap(n -> ((DoubleStream)mapper.apply((double)n)).boxed()));
    }

    @Override
    public DistributedDoubleStream distinct() {
        return this.wrap(this.inner.distinct());
    }

    @Override
    public DistributedDoubleStream sorted() {
        return this.wrap(this.inner.sorted());
    }

    @Override
    public DistributedDoubleStream peek(DoubleConsumer action) {
        return this.wrap(this.inner.peek(action::accept));
    }

    @Override
    public DistributedDoubleStream limit(long maxSize) {
        return this.wrap(this.inner.limit(maxSize));
    }

    @Override
    public DistributedDoubleStream skip(long n) {
        return this.wrap(this.inner.skip(n));
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.inner.forEach(action::accept);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.inner.forEachOrdered(action::accept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] toArray() {
        IList list = this.inner.collect(DistributedCollectors.toIList(StreamUtil.uniqueListName()));
        try {
            double[] array = new double[list.size()];
            int index = 0;
            for (Double d : list) {
                array[index++] = d;
            }
            Object object = array;
            return object;
        }
        finally {
            list.destroy();
        }
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return this.inner.reduce(Double.valueOf(identity), op::applyAsDouble);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        Optional result = this.inner.reduce(op::applyAsDouble);
        return result.isPresent() ? OptionalDouble.of((Double)result.get()) : OptionalDouble.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        DistributedBiConsumer boxedAccumulator = accumulator::accept;
        return this.inner.collect(supplier, boxedAccumulator, combiner);
    }

    @Override
    public double sum() {
        return this.inner.reduce(Double.valueOf(0.0), (a, b) -> a + b);
    }

    @Override
    public OptionalDouble min() {
        return DoublePipeline.toOptionalDouble(this.inner.min(DistributedComparator.naturalOrder()));
    }

    @Override
    public OptionalDouble max() {
        return DoublePipeline.toOptionalDouble(this.inner.max(DistributedComparator.naturalOrder()));
    }

    @Override
    public long count() {
        return this.inner.count();
    }

    @Override
    public OptionalDouble average() {
        double[] avg = (double[])this.collect(() -> new double[2], (ll, i) -> {
            ll[0] = ll[0] + 1.0;
            ll[1] = ll[1] + i;
        }, (ll, rr) -> {
            ll[0] = ll[0] + rr[0];
            ll[1] = ll[1] + rr[1];
        });
        return avg[0] > 0.0 ? OptionalDouble.of(avg[1] / avg[0]) : OptionalDouble.empty();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return (DoubleSummaryStatistics)this.collect(DistributedDoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return this.inner.anyMatch(predicate::test);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return this.inner.allMatch(predicate::test);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return this.inner.noneMatch(predicate::test);
    }

    @Override
    public OptionalDouble findFirst() {
        return DoublePipeline.toOptionalDouble(this.inner.findFirst());
    }

    @Override
    public OptionalDouble findAny() {
        return DoublePipeline.toOptionalDouble(this.inner.findAny());
    }

    @Override
    public DistributedStream<Double> boxed() {
        return this.inner;
    }

    @Override
    public DistributedDoubleStream sequential() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DistributedDoubleStream parallel() {
        return this;
    }

    @Override
    public DistributedDoubleStream unordered() {
        return this.wrap((Stream<Double>)this.inner.unordered());
    }

    @Override
    public DistributedDoubleStream onClose(Runnable closeHandler) {
        return this.wrap((Stream)this.inner.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        final Iterator iterator = this.inner.iterator();
        return new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return (Double)iterator.next();
            }
        };
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isParallel() {
        return this.inner.isParallel();
    }

    @Override
    public DistributedDoubleStream configure(JobConfig jobConfig) {
        return this.wrap(this.inner.configure(jobConfig));
    }

    private DistributedDoubleStream wrap(Stream<Double> pipeline) {
        return new DoublePipeline(this.context, (Pipe)pipeline);
    }

    private static OptionalDouble toOptionalDouble(Optional<Double> optional) {
        return optional.isPresent() ? OptionalDouble.of(optional.get()) : OptionalDouble.empty();
    }
}

