/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.stream.impl.pipeline;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.stream.impl.StreamUtil;
import com.hazelcast.jet.stream.impl.pipeline.AbstractIntermediatePipe;
import com.hazelcast.jet.stream.impl.pipeline.Pipe;
import com.hazelcast.jet.stream.impl.pipeline.StreamContext;
import com.hazelcast.jet.stream.impl.processor.LimitP;

class LimitPipe<T>
extends AbstractIntermediatePipe<T, T> {
    private final long limit;

    LimitPipe(StreamContext context, Pipe<T> upstream, long limit) {
        super(context, upstream.isOrdered(), upstream);
        this.limit = limit;
    }

    @Override
    public Vertex buildDAG(DAG dag) {
        Vertex previous = this.upstream.buildDAG(dag);
        long lim = this.limit;
        Vertex first = dag.newVertex(StreamUtil.uniqueVertexName("limit-local"), () -> new LimitP(lim)).localParallelism(1);
        dag.edge(Edge.between(previous, first));
        if (this.upstream.isOrdered()) {
            return first;
        }
        Vertex second = dag.newVertex(StreamUtil.uniqueVertexName("limit-distributed"), () -> new LimitP(lim)).localParallelism(1);
        dag.edge(Edge.between(first, second).distributed().allToOne());
        return second;
    }
}

