/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.impl.PacketHandler;

public final class PacketDispatcher
implements PacketHandler {
    private final ILogger logger;
    private final PacketHandler eventService;
    private final PacketHandler operationExecutor;
    private final PacketHandler jetService;
    private final PacketHandler connectionManager;
    private final PacketHandler responseHandler;
    private final PacketHandler invocationMonitor;

    public PacketDispatcher(ILogger logger, PacketHandler operationExecutor, PacketHandler responseHandler, PacketHandler invocationMonitor, PacketHandler eventService, PacketHandler connectionManager, PacketHandler jetService) {
        this.logger = logger;
        this.responseHandler = responseHandler;
        this.eventService = eventService;
        this.invocationMonitor = invocationMonitor;
        this.connectionManager = connectionManager;
        this.operationExecutor = operationExecutor;
        this.jetService = jetService;
    }

    @Override
    public void handle(Packet packet) throws Exception {
        try {
            switch (packet.getPacketType()) {
                case OPERATION: {
                    if (packet.isFlagRaised(2)) {
                        this.responseHandler.handle(packet);
                        break;
                    }
                    if (packet.isFlagRaised(64)) {
                        this.invocationMonitor.handle(packet);
                        break;
                    }
                    this.operationExecutor.handle(packet);
                    break;
                }
                case EVENT: {
                    this.eventService.handle(packet);
                    break;
                }
                case BIND: {
                    this.connectionManager.handle(packet);
                    break;
                }
                case JET: {
                    this.jetService.handle(packet);
                    break;
                }
                default: {
                    this.logger.severe("Header flags [" + Integer.toBinaryString(packet.getFlags()) + "] specify an undefined packet type " + packet.getPacketType().name());
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
            this.logger.severe("Failed to process:" + packet, t);
        }
    }
}

