/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.impl.execution.BroadcastEntry;
import com.hazelcast.jet.impl.execution.DoneItem;
import com.hazelcast.jet.impl.execution.SnapshotBarrier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;

class ExecutionSerializerHooks {
    ExecutionSerializerHooks() {
    }

    public static final class BroadcastKeyHook
    implements SerializerHook<BroadcastKey> {
        @Override
        public Class<BroadcastKey> getSerializationType() {
            return BroadcastKey.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<BroadcastKey>(){

                @Override
                public int getTypeId() {
                    return -320;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, BroadcastKey object) throws IOException {
                    out.writeObject(object.key());
                }

                @Override
                public BroadcastKey read(ObjectDataInput in) throws IOException {
                    return BroadcastKey.broadcastKey(in.readObject());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class BroadcastEntryHook
    implements SerializerHook<BroadcastEntry> {
        @Override
        public Class<BroadcastEntry> getSerializationType() {
            return BroadcastEntry.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<BroadcastEntry>(){

                @Override
                public int getTypeId() {
                    return -319;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, BroadcastEntry object) throws IOException {
                    out.writeObject(object.getKey());
                    out.writeObject(object.getValue());
                }

                @Override
                public BroadcastEntry read(ObjectDataInput in) throws IOException {
                    return new BroadcastEntry(in.readObject(), in.readObject());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class SnapshotBarrierHook
    implements SerializerHook<SnapshotBarrier> {
        @Override
        public Class<SnapshotBarrier> getSerializationType() {
            return SnapshotBarrier.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<SnapshotBarrier>(){

                @Override
                public int getTypeId() {
                    return -317;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, SnapshotBarrier object) throws IOException {
                    out.writeLong(object.snapshotId());
                    out.writeBoolean(object.isTerminal());
                }

                @Override
                public SnapshotBarrier read(ObjectDataInput in) throws IOException {
                    return new SnapshotBarrier(in.readLong(), in.readBoolean());
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class DoneItemHook
    implements SerializerHook<DoneItem> {
        @Override
        public Class<DoneItem> getSerializationType() {
            return DoneItem.class;
        }

        @Override
        public Serializer createSerializer() {
            return new StreamSerializer<DoneItem>(){

                @Override
                public int getTypeId() {
                    return -318;
                }

                @Override
                public void destroy() {
                }

                @Override
                public void write(ObjectDataOutput out, DoneItem object) {
                }

                @Override
                public DoneItem read(ObjectDataInput in) {
                    return DoneItem.DONE_ITEM;
                }
            };
        }

        @Override
        public boolean isOverwritable() {
            return true;
        }
    }
}

