/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics.management;

import com.hazelcast.jet.impl.metrics.management.ConcurrentArrayRingbuffer;
import com.hazelcast.jet.impl.metrics.management.ManagementCenterPublisher;
import com.hazelcast.jet.impl.metrics.management.Metric;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class MetricsResultSet {
    private final long nextSequence;
    private final List<MetricsCollection> collections;

    public MetricsResultSet(ConcurrentArrayRingbuffer.RingbufferSlice<Map.Entry<Long, byte[]>> slice) {
        this.nextSequence = slice.nextSequence();
        this.collections = slice.stream().map(e -> new MetricsCollection((Long)e.getKey(), (byte[])e.getValue())).collect(Collectors.toList());
    }

    public long nextSequence() {
        return this.nextSequence;
    }

    public List<MetricsCollection> collections() {
        return this.collections;
    }

    public static class MetricsCollection
    implements Iterable<Metric> {
        private final long timestamp;
        private final byte[] bytes;

        public MetricsCollection(long timestamp, byte[] bytes) {
            this.timestamp = timestamp;
            this.bytes = bytes;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public int sizeInBytes() {
            return this.bytes.length;
        }

        @Override
        @Nonnull
        public Iterator<Metric> iterator() {
            return ManagementCenterPublisher.decompressingIterator(this.bytes);
        }
    }
}

