/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.function.DistributedBiFunction;
import com.hazelcast.jet.function.DistributedBiPredicate;
import com.hazelcast.jet.function.DistributedFunction;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.ProcessorTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.ContextFactory;
import javax.annotation.Nonnull;

public final class PartitionedProcessorTransform<T, K>
extends ProcessorTransform {
    private final DistributedFunction<? super T, ? extends K> partitionKeyFn;

    private PartitionedProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorSupplier processorSupplier, @Nonnull DistributedFunction<? super T, ? extends K> partitionKeyFn) {
        super(name, upstream, processorSupplier);
        this.partitionKeyFn = partitionKeyFn;
    }

    public static <T, K> PartitionedProcessorTransform<T, K> partitionedCustomProcessorTransform(@Nonnull String name, @Nonnull Transform upstream, @Nonnull ProcessorSupplier processorSupplier, @Nonnull DistributedFunction<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>(name, upstream, processorSupplier, partitionKeyFn);
    }

    public static <C, T, K, R> PartitionedProcessorTransform<T, K> mapUsingContextPartitionedTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedBiFunction<? super C, ? super T, ? extends R> mapFn, @Nonnull DistributedFunction<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("mapUsingPartitionedContext", upstream, Processors.mapUsingContextP(contextFactory, mapFn), partitionKeyFn);
    }

    public static <C, T, K> PartitionedProcessorTransform<T, K> filterUsingPartitionedContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedBiPredicate<? super C, ? super T> filterFn, @Nonnull DistributedFunction<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("filterUsingPartitionedContext", upstream, Processors.filterUsingContextP(contextFactory, filterFn), partitionKeyFn);
    }

    public static <C, T, K, R> PartitionedProcessorTransform<T, K> flatMapUsingPartitionedContextTransform(@Nonnull Transform upstream, @Nonnull ContextFactory<C> contextFactory, @Nonnull DistributedBiFunction<? super C, ? super T, ? extends Traverser<? extends R>> flatMapFn, @Nonnull DistributedFunction<? super T, ? extends K> partitionKeyFn) {
        return new PartitionedProcessorTransform<T, K>("flatMapUsingPartitionedContext", upstream, Processors.flatMapUsingContextP(contextFactory, flatMapFn), partitionKeyFn);
    }

    @Override
    public void addToDag(Planner p) {
        Planner.PlannerVertex pv = p.addVertex((Transform)this, p.uniqueVertexName(this.name(), ""), this.localParallelism(), this.processorSupplier);
        p.addEdges((Transform)this, pv.v, e -> e.partitioned(this.partitionKeyFn).distributed());
    }
}

